/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import io.netty.util.internal.PlatformDependent;
import java.util.List;
import java.util.Queue;
import org.redisson.client.handler.CommandDecoder;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.QueueCommandHolder;

public class CommandsQueue
extends ChannelOutboundHandlerAdapter {
    public static final AttributeKey<QueueCommand> CURRENT_COMMAND = AttributeKey.valueOf("promise");
    private final Queue<QueueCommandHolder> queue = PlatformDependent.newMpscQueue();
    private final ChannelFutureListener listener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                CommandsQueue.this.sendNextCommand(future.channel());
            }
        }
    };

    public void sendNextCommand(Channel channel) {
        channel.attr(CURRENT_COMMAND).remove();
        this.queue.poll();
        this.sendData(channel);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof QueueCommand) {
            QueueCommand data = (QueueCommand)msg;
            QueueCommandHolder holder = this.queue.peek();
            if (holder != null && holder.getCommand() == data) {
                super.write(ctx, msg, promise);
            } else {
                this.queue.add(new QueueCommandHolder(data, promise));
                this.sendData(ctx.channel());
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private void sendData(Channel ch) {
        QueueCommandHolder command = this.queue.peek();
        if (command != null && command.trySend()) {
            QueueCommand data = command.getCommand();
            List<CommandData<Object, Object>> pubSubOps = data.getPubSubOperations();
            if (!pubSubOps.isEmpty()) {
                for (CommandData<Object, Object> cd : pubSubOps) {
                    for (Object channel : cd.getParams()) {
                        ch.pipeline().get(CommandDecoder.class).addPubSubCommand(channel.toString(), cd);
                    }
                }
            } else {
                ch.attr(CURRENT_COMMAND).set(data);
            }
            command.getChannelPromise().addListener(this.listener);
            ch.writeAndFlush(data, command.getChannelPromise());
        }
    }
}

