/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class RemoteInvocationOptions
implements Serializable {
    private Long ackTimeoutInMillis;
    private Long executionTimeoutInMillis;

    private RemoteInvocationOptions() {
    }

    public RemoteInvocationOptions(RemoteInvocationOptions copy) {
        this.ackTimeoutInMillis = copy.ackTimeoutInMillis;
        this.executionTimeoutInMillis = copy.executionTimeoutInMillis;
    }

    public static RemoteInvocationOptions defaults() {
        return new RemoteInvocationOptions().expectAckWithin(1L, TimeUnit.SECONDS).expectResultWithin(20L, TimeUnit.SECONDS);
    }

    public Long getAckTimeoutInMillis() {
        return this.ackTimeoutInMillis;
    }

    public Long getExecutionTimeoutInMillis() {
        return this.executionTimeoutInMillis;
    }

    public boolean isAckExpected() {
        return this.ackTimeoutInMillis != null;
    }

    public boolean isResultExpected() {
        return this.executionTimeoutInMillis != null;
    }

    public RemoteInvocationOptions expectAckWithin(long ackTimeoutInMillis) {
        this.ackTimeoutInMillis = ackTimeoutInMillis;
        return this;
    }

    public RemoteInvocationOptions expectAckWithin(long ackTimeout, TimeUnit timeUnit) {
        this.ackTimeoutInMillis = timeUnit.toMillis(ackTimeout);
        return this;
    }

    public RemoteInvocationOptions noAck() {
        this.ackTimeoutInMillis = null;
        return this;
    }

    public RemoteInvocationOptions expectResultWithin(long executionTimeoutInMillis) {
        this.executionTimeoutInMillis = executionTimeoutInMillis;
        return this;
    }

    public RemoteInvocationOptions expectResultWithin(long executionTimeout, TimeUnit timeUnit) {
        this.executionTimeoutInMillis = timeUnit.toMillis(executionTimeout);
        return this;
    }

    public RemoteInvocationOptions noResult() {
        this.executionTimeoutInMillis = null;
        return this;
    }

    public String toString() {
        return "RemoteInvocationOptions[ackTimeoutInMillis=" + this.ackTimeoutInMillis + ", executionTimeoutInMillis=" + this.executionTimeoutInMillis + ']';
    }
}

