/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.RedissonClient;
import org.redisson.config.RedissonNodeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonNode {
    private static final Logger log = LoggerFactory.getLogger(RedissonNode.class);

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException();
        }
        String configPath = args[0];
        RedissonNodeConfig config = null;
        try {
            config = RedissonNodeConfig.fromJSON(new File(configPath));
        }
        catch (IOException e) {
            try {
                config = RedissonNodeConfig.fromYAML(new File(configPath));
            }
            catch (IOException e1) {
                throw new IllegalArgumentException("Can't parse config file " + configPath);
            }
        }
        RedissonNode.start(config);
    }

    public static void start(RedissonNodeConfig config) {
        if (config.getExecutorServiceWorkers().isEmpty()) {
            throw new IllegalArgumentException("Executor service workers are empty");
        }
        final ExecutorService executor = config.getExecutorServiceThreads() == 0 ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2) : (config.getExecutorServiceThreads() > 0 ? Executors.newFixedThreadPool(config.getExecutorServiceThreads()) : null);
        final RedissonClient redisson = Redisson.create(config);
        for (Map.Entry<String, Integer> entry : config.getExecutorServiceWorkers().entrySet()) {
            String name = entry.getKey();
            int workers = entry.getValue();
            redisson.getExecutorService(name).registerWorkers(workers, executor);
            log.info("{} worker(s) for '{}' ExecutorService registered", (Object)workers, (Object)name);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                redisson.shutdown();
                if (executor != null) {
                    log.info("Worker executor is being shutdown...");
                    executor.shutdown();
                    try {
                        if (executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                            log.info("Worker executor has been shutdown successfully");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        log.info("Redisson node started!");
    }
}

