/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Promise;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.redisson.PubSubEntry;

public class RedissonLockEntry
implements PubSubEntry<RedissonLockEntry> {
    private int counter;
    private final Semaphore latch;
    private final Promise<RedissonLockEntry> promise;
    private final ConcurrentLinkedQueue<Runnable> listeners = new ConcurrentLinkedQueue();

    public RedissonLockEntry(Promise<RedissonLockEntry> promise) {
        this.latch = new Semaphore(0);
        this.promise = promise;
    }

    @Override
    public void aquire() {
        ++this.counter;
    }

    @Override
    public int release() {
        return --this.counter;
    }

    @Override
    public Promise<RedissonLockEntry> getPromise() {
        return this.promise;
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(Runnable listener) {
        return this.listeners.remove(listener);
    }

    public ConcurrentLinkedQueue<Runnable> getListeners() {
        return this.listeners;
    }

    public Semaphore getLatch() {
        return this.latch;
    }
}

