/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import org.redisson.PubSubEntry;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandExecutor;
import org.redisson.pubsub.LockPubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonLock
extends RedissonExpirable
implements RLock {
    private final Logger log = LoggerFactory.getLogger(RedissonLock.class);
    public static final long LOCK_EXPIRATION_INTERVAL_SECONDS = 30L;
    private static final ConcurrentMap<String, Timeout> expirationRenewalMap = PlatformDependent.newConcurrentHashMap();
    protected long internalLockLeaseTime = TimeUnit.SECONDS.toMillis(30L);
    final UUID id;
    protected static final LockPubSub PUBSUB = new LockPubSub();
    final CommandExecutor commandExecutor;

    protected RedissonLock(CommandExecutor commandExecutor, String name, UUID id) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.id = id;
    }

    protected String getEntryName() {
        return this.id + ":" + this.getName();
    }

    String getChannelName() {
        if (this.getName().contains("{")) {
            return "redisson_lock__channel:" + this.getName();
        }
        return "redisson_lock__channel__{" + this.getName() + "}";
    }

    String getLockName(long threadId) {
        return this.id + ":" + threadId;
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        Long ttl = this.tryAcquire(leaseTime, unit);
        if (ttl == null) {
            return;
        }
        long threadId = Thread.currentThread().getId();
        Future<RedissonLockEntry> future = this.subscribe(threadId);
        this.get(future);
        try {
            while ((ttl = this.tryAcquire(leaseTime, unit)) != null) {
                if (ttl >= 0L) {
                    this.getEntry(threadId).getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    continue;
                }
                this.getEntry(threadId).getLatch().acquire();
            }
        }
        finally {
            this.unsubscribe(future, threadId);
        }
    }

    private Long tryAcquire(long leaseTime, TimeUnit unit) {
        return this.get(this.tryAcquireAsync(leaseTime, unit, Thread.currentThread().getId()));
    }

    private Future<Boolean> tryAcquireOnceAsync(long leaseTime, TimeUnit unit, long threadId) {
        if (leaseTime != -1L) {
            return this.tryLockInnerAsync(leaseTime, unit, threadId, RedisCommands.EVAL_NULL_BOOLEAN);
        }
        Future<Boolean> ttlRemainingFuture = this.tryLockInnerAsync(30L, TimeUnit.SECONDS, threadId, RedisCommands.EVAL_NULL_BOOLEAN);
        ttlRemainingFuture.addListener((GenericFutureListener<Future<Boolean>>)new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Boolean ttlRemaining = future.getNow();
                if (ttlRemaining.booleanValue()) {
                    RedissonLock.this.scheduleExpirationRenewal();
                }
            }
        });
        return ttlRemainingFuture;
    }

    private <T> Future<Long> tryAcquireAsync(long leaseTime, TimeUnit unit, long threadId) {
        if (leaseTime != -1L) {
            return this.tryLockInnerAsync(leaseTime, unit, threadId, RedisCommands.EVAL_LONG);
        }
        Future<Long> ttlRemainingFuture = this.tryLockInnerAsync(30L, TimeUnit.SECONDS, threadId, RedisCommands.EVAL_LONG);
        ttlRemainingFuture.addListener((GenericFutureListener<Future<Long>>)new FutureListener<Long>(){

            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Long ttlRemaining = future.getNow();
                if (ttlRemaining == null) {
                    RedissonLock.this.scheduleExpirationRenewal();
                }
            }
        });
        return ttlRemainingFuture;
    }

    @Override
    public boolean tryLock() {
        return this.get(this.tryLockAsync());
    }

    private void scheduleExpirationRenewal() {
        if (expirationRenewalMap.containsKey(this.getEntryName())) {
            return;
        }
        Timeout task = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                Future future = RedissonLock.this.expireAsync(RedissonLock.this.internalLockLeaseTime, TimeUnit.MILLISECONDS);
                future.addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        expirationRenewalMap.remove(RedissonLock.this.getEntryName());
                        if (!future.isSuccess()) {
                            RedissonLock.this.log.error("Can't update lock " + RedissonLock.this.getName() + " expiration", future.cause());
                            return;
                        }
                        if (future.getNow().booleanValue()) {
                            RedissonLock.this.scheduleExpirationRenewal();
                        }
                    }
                });
            }
        }, this.internalLockLeaseTime / 3L, TimeUnit.MILLISECONDS);
        if (expirationRenewalMap.putIfAbsent(this.getEntryName(), task) != null) {
            task.cancel();
        }
    }

    void cancelExpirationRenewal() {
        Timeout task = (Timeout)expirationRenewalMap.remove(this.getEntryName());
        if (task != null) {
            task.cancel();
        }
    }

    <T> Future<T> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hset', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; return redis.call('pttl', KEYS[1]);", Collections.singletonList(this.getName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        Long ttl = this.tryAcquire(leaseTime, unit);
        if (ttl == null) {
            return true;
        }
        final long threadId = Thread.currentThread().getId();
        Future<RedissonLockEntry> future = this.subscribe(threadId);
        if (!this.await(future, time, TimeUnit.MILLISECONDS)) {
            if (!future.cancel(false)) {
                future.addListener((GenericFutureListener<Future<RedissonLockEntry>>)new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (future.isSuccess()) {
                            RedissonLock.this.unsubscribe(future, threadId);
                        }
                    }
                });
            }
            return false;
        }
        try {
            while (true) {
                if ((ttl = this.tryAcquire(leaseTime, unit)) == null) {
                    boolean bl = true;
                    return bl;
                }
                if (time <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                long current = System.currentTimeMillis();
                if (ttl >= 0L && ttl < time) {
                    this.getEntry(threadId).getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                } else {
                    this.getEntry(threadId).getLatch().tryAcquire(time, TimeUnit.MILLISECONDS);
                }
                long elapsed = System.currentTimeMillis() - current;
                time -= elapsed;
            }
        }
        finally {
            this.unsubscribe(future, threadId);
        }
    }

    protected RedissonLockEntry getEntry(long threadId) {
        return (RedissonLockEntry)PUBSUB.getEntry(this.getEntryName());
    }

    protected Future<RedissonLockEntry> subscribe(long threadId) {
        return PUBSUB.subscribe(this.getEntryName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    protected void unsubscribe(Future<RedissonLockEntry> future, long threadId) {
        PUBSUB.unsubscribe((PubSubEntry)future.getNow(), this.getEntryName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    @Override
    public void unlock() {
        Boolean opStatus = (Boolean)this.commandExecutor.evalWrite(this.getName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('publish', KEYS[2], ARGV[1]); return 1; end;if (redis.call('hexists', KEYS[1], ARGV[3]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); return 0; else redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; end; return nil;", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.unlockMessage, this.internalLockLeaseTime, this.getLockName(Thread.currentThread().getId()));
        if (opStatus == null) {
            throw new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + this.id + " thread-id: " + Thread.currentThread().getId());
        }
        if (opStatus.booleanValue()) {
            this.cancelExpirationRenewal();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceUnlock() {
        this.get(this.forceUnlockAsync());
    }

    @Override
    public Future<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal();
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('del', KEYS[1]) == 1) then redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.unlockMessage);
    }

    @Override
    public boolean isLocked() {
        return this.isExists();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return (Boolean)this.commandExecutor.write(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HEXISTS, this.getName(), this.getLockName(Thread.currentThread().getId()));
    }

    @Override
    public int getHoldCount() {
        Long res = (Long)this.commandExecutor.write(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HGET, this.getName(), this.getLockName(Thread.currentThread().getId()));
        if (res == null) {
            return 0;
        }
        return res.intValue();
    }

    @Override
    public Future<Boolean> deleteAsync() {
        return this.forceUnlockAsync();
    }

    @Override
    public Future<Void> unlockAsync() {
        long threadId = Thread.currentThread().getId();
        return this.unlockAsync(threadId);
    }

    public Future<Void> unlockAsync(final long threadId) {
        final Promise<Void> result = this.newPromise();
        Future future = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('publish', KEYS[2], ARGV[1]); return 1; end;if (redis.call('hexists', KEYS[1], ARGV[3]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); return 0; else redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; end; return nil;", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.unlockMessage, this.internalLockLeaseTime, this.getLockName(threadId));
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setFailure(future.cause());
                    return;
                }
                Boolean opStatus = future.getNow();
                if (opStatus == null) {
                    IllegalMonitorStateException cause = new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + RedissonLock.this.id + " thread-id: " + threadId);
                    result.setFailure(cause);
                    return;
                }
                if (opStatus.booleanValue()) {
                    RedissonLock.this.cancelExpirationRenewal();
                }
                result.setSuccess(null);
            }
        });
        return result;
    }

    @Override
    public Future<Void> lockAsync() {
        return this.lockAsync(-1L, null);
    }

    @Override
    public Future<Void> lockAsync(long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.lockAsync(leaseTime, unit, currentThreadId);
    }

    public Future<Void> lockAsync(final long leaseTime, final TimeUnit unit, final long currentThreadId) {
        final Promise<Void> result = this.newPromise();
        Future<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.addListener((GenericFutureListener<Future<Long>>)new FutureListener<Long>(){

            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setFailure(future.cause());
                    return;
                }
                Long ttl = future.getNow();
                if (ttl == null) {
                    result.setSuccess(null);
                    return;
                }
                final Future<RedissonLockEntry> subscribeFuture = RedissonLock.this.subscribe(currentThreadId);
                subscribeFuture.addListener((GenericFutureListener<Future<RedissonLockEntry>>)new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.setFailure(future.cause());
                            return;
                        }
                        RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                    }
                });
            }
        });
        return result;
    }

    private void lockAsync(final long leaseTime, final TimeUnit unit, final Future<RedissonLockEntry> subscribeFuture, final Promise<Void> result, final long currentThreadId) {
        Future<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.addListener((GenericFutureListener<Future<Long>>)new FutureListener<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                RedissonLockEntry entry;
                if (!future.isSuccess()) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    result.setFailure(future.cause());
                    return;
                }
                Long ttl = future.getNow();
                if (ttl == null) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    result.setSuccess(null);
                    return;
                }
                RedissonLockEntry redissonLockEntry = entry = RedissonLock.this.getEntry(currentThreadId);
                synchronized (redissonLockEntry) {
                    if (entry.getLatch().tryAcquire()) {
                        RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                    } else {
                        final AtomicReference futureRef = new AtomicReference();
                        final Runnable listener = new Runnable(){

                            @Override
                            public void run() {
                                if (futureRef.get() != null) {
                                    ((ScheduledFuture)futureRef.get()).cancel(false);
                                }
                                RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                            }
                        };
                        entry.addListener(listener);
                        if (ttl >= 0L) {
                            ScheduledFuture<?> scheduledFuture = RedissonLock.this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    RedissonLockEntry redissonLockEntry = entry;
                                    synchronized (redissonLockEntry) {
                                        if (entry.removeListener(listener)) {
                                            RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                                        }
                                    }
                                }
                            }, (long)ttl, TimeUnit.MILLISECONDS);
                            futureRef.set(scheduledFuture);
                        }
                    }
                }
            }
        });
    }

    @Override
    public Future<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    public Future<Boolean> tryLockAsync(long threadId) {
        return this.tryAcquireOnceAsync(-1L, null, threadId);
    }

    @Override
    public Future<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public Future<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.tryLockAsync(waitTime, leaseTime, unit, currentThreadId);
    }

    public Future<Boolean> tryLockAsync(long waitTime, final long leaseTime, final TimeUnit unit, final long currentThreadId) {
        final Promise<Boolean> result = this.newPromise();
        final AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        Future<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.addListener((GenericFutureListener<Future<Long>>)new FutureListener<Long>(){

            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setFailure(future.cause());
                    return;
                }
                Long ttl = future.getNow();
                if (ttl == null) {
                    result.setSuccess(true);
                    return;
                }
                final long current = System.currentTimeMillis();
                final AtomicReference futureRef = new AtomicReference();
                final Future<RedissonLockEntry> subscribeFuture = RedissonLock.this.subscribe(currentThreadId);
                subscribeFuture.addListener((GenericFutureListener<Future<RedissonLockEntry>>)new FutureListener<RedissonLockEntry>(){

                    @Override
                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (futureRef.get() != null) {
                            ((ScheduledFuture)futureRef.get()).cancel(false);
                        }
                        long elapsed = System.currentTimeMillis() - current;
                        time.addAndGet(-elapsed);
                        if (time.get() < 0L) {
                            RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                            result.trySuccess(false);
                            return;
                        }
                        RedissonLock.this.tryLockAsync(time, leaseTime, unit, subscribeFuture, result, currentThreadId);
                    }
                });
                if (!subscribeFuture.isDone()) {
                    ScheduledFuture<?> scheduledFuture = RedissonLock.this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                        @Override
                        public void run() {
                            if (!subscribeFuture.isDone()) {
                                subscribeFuture.cancel(false);
                                result.trySuccess(false);
                            }
                        }
                    }, time.get(), TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
        return result;
    }

    private void tryLockAsync(final AtomicLong time, final long leaseTime, final TimeUnit unit, final Future<RedissonLockEntry> subscribeFuture, final Promise<Boolean> result, final long currentThreadId) {
        Future<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.addListener((GenericFutureListener<Future<Long>>)new FutureListener<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<Long> future) throws Exception {
                RedissonLockEntry entry;
                if (!future.isSuccess()) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    result.tryFailure(future.cause());
                    return;
                }
                Long ttl = future.getNow();
                if (ttl == null) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    result.trySuccess(true);
                    return;
                }
                if (time.get() < 0L) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    result.trySuccess(false);
                    return;
                }
                final long current = System.currentTimeMillis();
                RedissonLockEntry redissonLockEntry = entry = RedissonLock.this.getEntry(currentThreadId);
                synchronized (redissonLockEntry) {
                    if (entry.getLatch().tryAcquire()) {
                        RedissonLock.this.tryLockAsync(time, leaseTime, unit, subscribeFuture, result, currentThreadId);
                    } else {
                        final AtomicBoolean executed = new AtomicBoolean();
                        final AtomicReference futureRef = new AtomicReference();
                        final Runnable listener = new Runnable(){

                            @Override
                            public void run() {
                                executed.set(true);
                                if (futureRef.get() != null) {
                                    ((ScheduledFuture)futureRef.get()).cancel(false);
                                }
                                long elapsed = System.currentTimeMillis() - current;
                                time.addAndGet(-elapsed);
                                RedissonLock.this.tryLockAsync(time, leaseTime, unit, subscribeFuture, result, currentThreadId);
                            }
                        };
                        entry.addListener(listener);
                        long t = time.get();
                        if (ttl >= 0L && ttl < time.get()) {
                            t = ttl;
                        }
                        if (!executed.get()) {
                            ScheduledFuture<?> scheduledFuture = RedissonLock.this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    RedissonLockEntry redissonLockEntry = entry;
                                    synchronized (redissonLockEntry) {
                                        if (entry.removeListener(listener)) {
                                            long elapsed = System.currentTimeMillis() - current;
                                            time.addAndGet(-elapsed);
                                            RedissonLock.this.tryLockAsync(time, leaseTime, unit, subscribeFuture, result, currentThreadId);
                                        }
                                    }
                                }
                            }, t, TimeUnit.MILLISECONDS);
                            futureRef.set(scheduledFuture);
                        }
                    }
                }
            }
        });
    }
}

