/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.redisson.PubSubEntry;
import org.redisson.RedissonLock;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandExecutor;
import org.redisson.pubsub.LockPubSub;

public class RedissonFairLock
extends RedissonLock
implements RLock {
    private final CommandExecutor commandExecutor;

    protected RedissonFairLock(CommandExecutor commandExecutor, String name, UUID id) {
        super(commandExecutor, name, id);
        this.commandExecutor = commandExecutor;
    }

    String getThreadsQueueName() {
        return "redisson_lock_queue:{" + this.getName() + "}";
    }

    String getThreadElementName(long threadId) {
        return "redisson_lock_thread:{" + this.getName() + "}:" + this.getLockName(threadId);
    }

    @Override
    protected RedissonLockEntry getEntry(long threadId) {
        return (RedissonLockEntry)PUBSUB.getEntry(this.getEntryName() + ":" + threadId);
    }

    @Override
    protected Future<RedissonLockEntry> subscribe(long threadId) {
        return PUBSUB.subscribe(this.getEntryName() + ":" + threadId, this.getChannelName() + ":" + this.getLockName(threadId), this.commandExecutor.getConnectionManager());
    }

    @Override
    protected void unsubscribe(Future<RedissonLockEntry> future, long threadId) {
        PUBSUB.unsubscribe((PubSubEntry)future.getNow(), this.getEntryName() + ":" + threadId, this.getChannelName() + ":" + this.getLockName(threadId), this.commandExecutor.getConnectionManager());
    }

    @Override
    <T> Future<T> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        long threadWaitTime = 5000L;
        if (command == RedisCommands.EVAL_NULL_BOOLEAN) {
            return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "while true do local firstThreadId2 = redis.call('lindex', KEYS[2], 0);if firstThreadId2 == false then break;end; if redis.call('exists', 'redisson_lock_thread:{' .. KEYS[1] .. '}:' .. firstThreadId2) == 0 then redis.call('lpop', KEYS[2]); else break;end; end;if (redis.call('exists', KEYS[1]) == 0) and ((redis.call('exists', KEYS[2]) == 0) or (redis.call('lindex', KEYS[2], 0) == ARGV[2])) then redis.call('lpop', KEYS[2]); redis.call('del', KEYS[3]); redis.call('hset', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; return 1;", Arrays.asList(this.getName(), this.getThreadsQueueName(), this.getThreadElementName(threadId)), this.internalLockLeaseTime, this.getLockName(threadId));
        }
        if (command == RedisCommands.EVAL_LONG) {
            return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "while true do local firstThreadId2 = redis.call('lindex', KEYS[2], 0);if firstThreadId2 == false then break;end; if redis.call('exists', 'redisson_lock_thread:{' .. KEYS[1] .. '}:' .. firstThreadId2) == 0 then redis.call('lpop', KEYS[2]); else break;end; end;if (redis.call('exists', KEYS[1]) == 0) and ((redis.call('exists', KEYS[2]) == 0) or (redis.call('lindex', KEYS[2], 0) == ARGV[2])) then redis.call('lpop', KEYS[2]); redis.call('del', KEYS[3]); redis.call('hset', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; local firstThreadId = redis.call('lindex', KEYS[2], 0)local ttl = redis.call('pttl', KEYS[1]); if firstThreadId ~= false and firstThreadId ~= ARGV[2] then ttl = redis.call('pttl', 'redisson_lock_thread:{' .. KEYS[1] .. '}:' .. firstThreadId);end; if redis.call('exists', KEYS[3]) == 0 then redis.call('rpush', KEYS[2], ARGV[2]);redis.call('set', KEYS[3], 1);end; redis.call('pexpire', KEYS[3], ttl + tonumber(ARGV[3]));return ttl;", Arrays.asList(this.getName(), this.getThreadsQueueName(), this.getThreadElementName(threadId)), this.internalLockLeaseTime, this.getLockName(threadId), threadWaitTime);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void unlock() {
        Boolean opStatus = (Boolean)this.commandExecutor.evalWrite(this.getName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "while true do local firstThreadId2 = redis.call('lindex', KEYS[2], 0);if firstThreadId2 == false then break;end; if redis.call('exists', 'redisson_lock_thread:{' .. KEYS[1] .. '}:' .. firstThreadId2) == 0 then redis.call('lpop', KEYS[2]); else break;end; end;if (redis.call('exists', KEYS[1]) == 0) then local nextThreadId = redis.call('lindex', KEYS[3], 0); if nextThreadId ~= false then redis.call('publish', KEYS[2] .. ':' .. nextThreadId, ARGV[1]); end; return 1; end;if (redis.call('hexists', KEYS[1], ARGV[3]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); return 0; else redis.call('del', KEYS[1]); local nextThreadId = redis.call('lindex', KEYS[3], 0); if nextThreadId ~= false then redis.call('publish', KEYS[2] .. ':' .. nextThreadId, ARGV[1]); end; return 1; end; return nil;", Arrays.asList(this.getName(), this.getChannelName(), this.getThreadsQueueName()), LockPubSub.unlockMessage, this.internalLockLeaseTime, this.getLockName(Thread.currentThread().getId()));
        if (opStatus == null) {
            throw new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + this.id + " thread-id: " + Thread.currentThread().getId());
        }
        if (opStatus.booleanValue()) {
            this.cancelExpirationRenewal();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal();
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "while true do local firstThreadId2 = redis.call('lindex', KEYS[2], 0);if firstThreadId2 == false then break;end; if redis.call('exists', 'redisson_lock_thread:{' .. KEYS[1] .. '}:' .. firstThreadId2) == 0 then redis.call('lpop', KEYS[2]); else break;end; end;if (redis.call('del', KEYS[1]) == 1) then local nextThreadId = redis.call('lindex', KEYS[3], 0); if nextThreadId ~= false then redis.call('publish', KEYS[2] .. ':' .. nextThreadId, ARGV[1]); end; return 1 end return 0;", Arrays.asList(this.getName(), this.getChannelName(), this.getThreadsQueueName()), LockPubSub.unlockMessage);
    }
}

