/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonObject;
import org.redisson.api.RExpirable;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

abstract class RedissonExpirable
extends RedissonObject
implements RExpirable {
    RedissonExpirable(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    RedissonExpirable(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public boolean expire(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.get(this.expireAsync(timeToLive, timeUnit));
    }

    @Override
    public Future<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIRE, this.getName(), timeUnit.toMillis(timeToLive));
    }

    @Override
    public boolean expireAt(long timestamp) {
        return this.commandExecutor.get(this.expireAtAsync(timestamp));
    }

    @Override
    public Future<Boolean> expireAtAsync(long timestamp) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIREAT, this.getName(), timestamp);
    }

    @Override
    public boolean expireAt(Date timestamp) {
        return this.expireAt(timestamp.getTime());
    }

    @Override
    public Future<Boolean> expireAtAsync(Date timestamp) {
        return this.expireAtAsync(timestamp.getTime());
    }

    @Override
    public boolean clearExpire() {
        return this.commandExecutor.get(this.clearExpireAsync());
    }

    @Override
    public Future<Boolean> clearExpireAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PERSIST, this.getName());
    }

    @Override
    public long remainTimeToLive() {
        return this.commandExecutor.get(this.remainTimeToLiveAsync());
    }

    @Override
    public Future<Long> remainTimeToLiveAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.PTTL, this.getName());
    }
}

