/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RBuckets;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DelegateDecoderCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.decoder.MapGetAllDecoder;

public class RedissonBuckets
implements RBuckets {
    private final Codec codec;
    private final CommandExecutor commandExecutor;
    private final Redisson redisson;

    public RedissonBuckets(Redisson redisson, CommandExecutor commandExecutor) {
        this(redisson, commandExecutor.getConnectionManager().getCodec(), commandExecutor);
    }

    public RedissonBuckets(Redisson redisson, Codec codec, CommandExecutor commandExecutor) {
        this.codec = codec;
        this.commandExecutor = commandExecutor;
        this.redisson = redisson;
    }

    @Override
    public <V> List<RBucket<V>> find(String pattern) {
        Collection keys = this.commandExecutor.get(this.commandExecutor.readAllAsync(RedisCommands.KEYS, pattern));
        ArrayList<RBucket<V>> buckets = new ArrayList<RBucket<V>>(keys.size());
        for (String key : keys) {
            if (key == null) continue;
            buckets.add(this.redisson.getBucket(key, this.codec));
        }
        return buckets;
    }

    @Override
    public <V> Map<String, V> get(String ... keys) {
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("MGET", new MapGetAllDecoder(Arrays.asList(keys), 0), RedisCommand.ValueType.OBJECTS);
        Future future = this.commandExecutor.readAsync(keys[0], (Codec)new DelegateDecoderCodec(this.codec), command, (Object[])keys);
        return (Map)this.commandExecutor.get(future);
    }

    @Override
    public boolean trySet(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return false;
        }
        ArrayList<Object> params = new ArrayList<Object>(buckets.size());
        for (Map.Entry<String, ?> entry : buckets.entrySet()) {
            params.add(entry.getKey());
            try {
                params.add(this.codec.getValueEncoder().encode(entry.getValue()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return (Boolean)this.commandExecutor.write(params.get(0).toString(), RedisCommands.MSETNX, params.toArray());
    }

    @Override
    public void set(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(buckets.size());
        for (Map.Entry<String, ?> entry : buckets.entrySet()) {
            params.add(entry.getKey());
            try {
                params.add(this.codec.getValueEncoder().encode(entry.getValue()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.commandExecutor.write(params.get(0).toString(), RedisCommands.MSET, params.toArray());
    }
}

