/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import org.redisson.RedissonExpirable;
import org.redisson.api.RBitSet;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;

public class RedissonBitSet
extends RedissonExpirable
implements RBitSet {
    public RedissonBitSet(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    @Override
    public long length() {
        return this.get(this.lengthAsync());
    }

    @Override
    public void set(BitSet bs) {
        this.get(this.setAsync(bs));
    }

    @Override
    public boolean get(long bitIndex) {
        return this.get(this.getAsync(bitIndex));
    }

    @Override
    public Future<Boolean> getAsync(long bitIndex) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.GETBIT, this.getName(), bitIndex);
    }

    @Override
    public void set(long bitIndex) {
        this.get(this.setAsync(bitIndex, true));
    }

    @Override
    public void set(long fromIndex, long toIndex, boolean value) {
        this.get(this.setAsync(fromIndex, toIndex, value));
    }

    @Override
    public void set(long fromIndex, long toIndex) {
        this.get(this.setAsync(fromIndex, toIndex));
    }

    @Override
    public void set(long bitIndex, boolean value) {
        this.get(this.setAsync(bitIndex, value));
    }

    @Override
    public Future<Void> setAsync(long bitIndex, boolean value) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.SETBIT_VOID, this.getName(), bitIndex, value ? 1 : 0);
    }

    @Override
    public byte[] toByteArray() {
        return this.get(this.toByteArrayAsync());
    }

    @Override
    public Future<byte[]> toByteArrayAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, this.getName());
    }

    @Override
    public long cardinality() {
        return this.get(this.cardinalityAsync());
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public void clear(long fromIndex, long toIndex) {
        this.get(this.clearAsync(fromIndex, toIndex));
    }

    @Override
    public void clear(long bitIndex) {
        this.get(this.clearAsync(bitIndex));
    }

    @Override
    public void clear() {
        this.get(this.clearAsync());
    }

    @Override
    public void or(String ... bitSetNames) {
        this.get(this.orAsync(bitSetNames));
    }

    @Override
    public void and(String ... bitSetNames) {
        this.get(this.andAsync(bitSetNames));
    }

    @Override
    public void xor(String ... bitSetNames) {
        this.get(this.xorAsync(bitSetNames));
    }

    @Override
    public void not() {
        this.get(this.notAsync());
    }

    private Future<Void> opAsync(String op, String ... bitSetNames) {
        ArrayList<String> params = new ArrayList<String>(bitSetNames.length + 3);
        params.add(op);
        params.add(this.getName());
        params.add(this.getName());
        params.addAll(Arrays.asList(bitSetNames));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.BITOP, params.toArray());
    }

    @Override
    public BitSet asBitSet() {
        return RedissonBitSet.fromByteArrayReverse(this.toByteArray());
    }

    private static BitSet fromByteArrayReverse(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[i / 8] & 1 << 7 - i % 8) == 0) continue;
            bits.set(i);
        }
        return bits;
    }

    private static byte[] toByteArrayReverse(BitSet bits) {
        byte[] bytes = new byte[bits.length() / 8 + 1];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int value = bytes[i / 8] | 1 << 7 - i % 8;
            bytes[i / 8] = (byte)value;
        }
        return bytes;
    }

    public String toString() {
        return this.asBitSet().toString();
    }

    @Override
    public Future<Long> lengthAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local fromBit = redis.call('bitpos', KEYS[1], 1, -1);local toBit = 8*(fromBit/8 + 1) - fromBit % 8;for i = toBit, fromBit, -1 do if redis.call('getbit', KEYS[1], i) == 1 then return i+1;end;end;return fromBit+1", Collections.singletonList(this.getName()), new Object[0]);
    }

    @Override
    public Future<Void> setAsync(long fromIndex, long toIndex, boolean value) {
        if (value) {
            return this.setAsync(fromIndex, toIndex);
        }
        return this.clearAsync(fromIndex, toIndex);
    }

    @Override
    public Future<Void> clearAsync(long fromIndex, long toIndex) {
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
        for (long i = fromIndex; i < toIndex; ++i) {
            executorService.writeAsync(this.getName(), this.codec, RedisCommands.SETBIT_VOID, this.getName(), i, 0);
        }
        return executorService.executeAsyncVoid();
    }

    @Override
    public Future<Void> setAsync(BitSet bs) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SET, this.getName(), RedissonBitSet.toByteArrayReverse(bs));
    }

    @Override
    public Future<Void> notAsync() {
        return this.opAsync("NOT", new String[0]);
    }

    @Override
    public Future<Void> setAsync(long fromIndex, long toIndex) {
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor.getConnectionManager());
        for (long i = fromIndex; i < toIndex; ++i) {
            executorService.writeAsync(this.getName(), this.codec, RedisCommands.SETBIT_VOID, this.getName(), i, 1);
        }
        return executorService.executeAsyncVoid();
    }

    @Override
    public Future<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.BITS_SIZE, this.getName());
    }

    @Override
    public Future<Void> setAsync(long bitIndex) {
        return this.setAsync(bitIndex, true);
    }

    @Override
    public Future<Long> cardinalityAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.BITCOUNT, this.getName());
    }

    @Override
    public Future<Void> clearAsync(long bitIndex) {
        return this.setAsync(bitIndex, false);
    }

    @Override
    public Future<Void> clearAsync() {
        return this.commandExecutor.writeAsync(this.getName(), RedisCommands.DEL_VOID, this.getName());
    }

    @Override
    public Future<Void> orAsync(String ... bitSetNames) {
        return this.opAsync("OR", bitSetNames);
    }

    @Override
    public Future<Void> andAsync(String ... bitSetNames) {
        return this.opAsync("AND", bitSetNames);
    }

    @Override
    public Future<Void> xorAsync(String ... bitSetNames) {
        return this.opAsync("XOR", bitSetNames);
    }
}

