/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strangefx.ui;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class MeasurementUI
extends Region {
    private Label label = new Label();
    private Pane progress = new Pane();
    private final DoubleProperty measuredChanceProperty = new SimpleDoubleProperty((Object)this, "measured chance", 0.0){

        public void set(double newValue) {
            double fval = newValue;
            if (fval < 0.0) {
                fval = 0.0;
            }
            if (fval > 1.0) {
                fval = 1.0;
            }
            super.set(fval);
        }
    };

    public MeasurementUI() {
        this.getStyleClass().add((Object)"measurement");
        this.initUI();
        this.updateMeasuredChance();
        this.measuredChanceProperty.addListener(o -> this.updateMeasuredChance());
    }

    private void initUI() {
        BorderPane progressBase = new BorderPane();
        progressBase.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        progressBase.setBottom((Node)this.progress);
        this.progress.setPrefHeight(0.0);
        this.progress.getStyleClass().add((Object)"progress");
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        StackPane stack = new StackPane(new Node[]{progressBase, this.label});
        stack.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        stack.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)stack);
        this.prefWidthProperty().bind((ObservableValue)this.heightProperty());
    }

    private void updateMeasuredChance() {
        this.label.setText(this.measuredChanceAsString());
        this.progress.prefHeightProperty().bind((ObservableValue)this.heightProperty().multiply(this.getMeasuredChance()));
    }

    private String measuredChanceAsString() {
        double chance = this.getMeasuredChance();
        if (chance == 0.0) {
            return "Off";
        }
        if (chance == 1.0) {
            return "On";
        }
        return String.format("%2.1f%%", chance * 100.0);
    }

    public final DoubleProperty measuredChanceProperty() {
        return this.measuredChanceProperty;
    }

    public final double getMeasuredChance() {
        return this.measuredChanceProperty.get();
    }

    public final void setMeasuredChance(double value) {
        this.measuredChanceProperty.set(value);
    }
}

