/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.Arrays;
import java.util.List;
import org.redfx.strange.Gate;

public abstract class TwoQubitGate
implements Gate {
    private int first;
    private int second;
    private int highest = -1;
    private boolean inverse;

    public TwoQubitGate() {
    }

    public TwoQubitGate(int first, int second) {
        this.first = first;
        this.second = second;
        this.highest = Math.max(first, second);
    }

    @Override
    public void setMainQubitIndex(int idx) {
        this.first = idx;
    }

    @Override
    public int getMainQubitIndex() {
        return this.first;
    }

    @Override
    public void setAdditionalQubit(int idx, int cnt) {
        this.second = idx;
    }

    public int getSecondQubitIndex() {
        return this.second;
    }

    public void setHighestAffectedQubitIndex(int v) {
        this.highest = v;
    }

    @Override
    public List<Integer> getAffectedQubitIndexes() {
        return Arrays.asList(this.first, this.second);
    }

    @Override
    public int getHighestAffectedQubitIndex() {
        return this.highest;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getCaption() {
        return this.getName();
    }

    @Override
    public String getGroup() {
        return "TwoQubit";
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public void setInverse(boolean v) {
        this.inverse = v;
    }

    public String toString() {
        return "Gate acting on qubits " + this.first + " and " + this.second + " and caption " + this.getCaption();
    }
}

