/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;

public class PermutationGate
implements Gate {
    private int a;
    private int b;
    private int n;
    private Complex[][] m;
    private List<Integer> affected = new LinkedList<Integer>();

    @Override
    public int getMainQubitIndex() {
        return this.a;
    }

    public PermutationGate(int a, int b, int n) {
        assert (a < n);
        assert (b < n);
        this.a = a;
        this.b = b;
        this.n = n;
        for (int i = 0; i < n; ++i) {
            this.affected.add(i);
        }
    }

    public int getIndex1() {
        return this.a;
    }

    public int getIndex2() {
        return this.b;
    }

    @Override
    public void setMainQubitIndex(int idx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAdditionalQubit(int idx, int cnt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Integer> getAffectedQubitIndexes() {
        return this.affected;
    }

    @Override
    public int getHighestAffectedQubitIndex() {
        return Collections.max(this.affected);
    }

    @Override
    public String getCaption() {
        return "P";
    }

    @Override
    public String getName() {
        return "permutation gate";
    }

    @Override
    public String getGroup() {
        return "permutation";
    }

    @Override
    public Complex[][] getMatrix() {
        throw new RuntimeException("No matrix required for Permutation");
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public void setInverse(boolean v) {
    }

    public String toString() {
        return "Perm " + this.a + ", " + this.b;
    }
}

