/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;

public class Oracle
implements Gate {
    private int mainQubit = 0;
    private List<Integer> affected = new LinkedList<Integer>();
    private Complex[][] matrix;
    private String caption = "Oracle";
    private int span = 1;

    public Oracle(int i) {
        this.mainQubit = i;
    }

    public Oracle(Complex[][] matrix) {
        this.matrix = matrix;
        this.sanitizeMatrix();
        this.span = (int)(Math.log(matrix.length) / Math.log(2.0));
        for (int i = 0; i < this.span; ++i) {
            this.setAdditionalQubit(i, i);
        }
    }

    @Override
    public int getSize() {
        return this.span;
    }

    public void setCaption(String c) {
        this.caption = c;
    }

    @Override
    public void setMainQubitIndex(int idx) {
        this.mainQubit = 0;
    }

    @Override
    public int getMainQubitIndex() {
        return this.mainQubit;
    }

    @Override
    public void setAdditionalQubit(int idx, int cnt) {
        this.affected.add(idx);
    }

    public int getQubits() {
        return this.span;
    }

    @Override
    public List<Integer> getAffectedQubitIndexes() {
        return this.affected;
    }

    @Override
    public int getHighestAffectedQubitIndex() {
        return Collections.max(this.getAffectedQubitIndexes());
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public String getName() {
        return "Oracle";
    }

    @Override
    public String getGroup() {
        return "Oracle";
    }

    @Override
    public Complex[][] getMatrix() {
        return this.matrix;
    }

    private void sanitizeMatrix() {
        int rows = this.matrix.length;
        for (int i = 0; i < rows; ++i) {
            Complex[] row = this.matrix[i];
            for (int j = 0; j < row.length; ++j) {
                if (this.matrix[i][j] != null) continue;
                this.matrix[i][j] = Complex.ZERO;
            }
        }
    }

    @Override
    public void setInverse(boolean inv) {
        if (inv) {
            this.matrix = Complex.conjugateTranspose(this.matrix);
        }
    }
}

