/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.ControlledBlockGate;
import org.redfx.strange.Step;
import org.redfx.strange.gate.AddIntegerModulus;
import org.redfx.strange.gate.Swap;
import org.redfx.strange.local.Computations;

public class MulModulus
extends BlockGate<MulModulus> {
    Block block;

    public MulModulus(int x0, int x1, int mul, int mod) {
        this.setIndex(x0);
        x1 -= x0;
        x0 = 0;
        this.block = this.createBlock(x0, x1, mul, mod);
        this.setBlock(this.block);
    }

    public Block createBlock(int y0, int y1, int mul, int mod) {
        int i;
        int size;
        int hash = 1000000 * y0 + 10000 * y1 + 100 * mul + mod;
        int x0 = y0;
        int x1 = y1 - y0;
        int n = size = x1 - x0 + 1;
        Block answer = new Block("MulModulus", 2 * size + 2);
        for (i = 0; i < n; ++i) {
            int m = mul * (1 << i) % mod;
            AddIntegerModulus add = new AddIntegerModulus(x0, x1 + 1, m, mod);
            ControlledBlockGate cbg = new ControlledBlockGate(add, n, i);
            answer.addStep(new Step(cbg));
        }
        for (i = x0; i < x1 + 1; ++i) {
            answer.addStep(new Step(new Swap(i, i + size)));
        }
        int invmul = Computations.getInverseModulus(mul, mod);
        for (int i2 = 0; i2 < n; ++i2) {
            int m = invmul * (1 << i2) % mod;
            AddIntegerModulus add = new AddIntegerModulus(x0, x1 + 1, m, mod);
            ControlledBlockGate cbg = new ControlledBlockGate(add, n, i2);
            cbg.setInverse(true);
            answer.addStep(new Step(cbg));
        }
        return answer;
    }
}

