/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import org.redfx.strange.Complex;
import org.redfx.strange.QuantumExecutionEnvironment;
import org.redfx.strange.gate.Fourier;

public class InvFourier
extends Fourier {
    public InvFourier(int size, int idx) {
        super("InvFourier", size, idx);
    }

    @Override
    public Complex[][] getMatrix() {
        return this.getMatrix(null);
    }

    @Override
    public Complex[][] getMatrix(QuantumExecutionEnvironment eqq) {
        if (this.matrix == null) {
            double omega = Math.PI * 2 / (double)this.size;
            double den = Math.sqrt(this.size);
            this.matrix = new Complex[this.size][this.size];
            for (int i = 0; i < this.size; ++i) {
                for (int j = i; j < this.size; ++j) {
                    double alpha = omega * (double)i * (double)j;
                    int tpd = (int)(alpha / (Math.PI * 2));
                    if (tpd > 0) {
                        alpha -= Math.PI * 2 * (double)tpd;
                    }
                    double ar = Math.cos(alpha);
                    double ai = Math.sin(alpha);
                    if (Math.abs(alpha) < 1.0E-6) {
                        ar = 1.0;
                        ai = 0.0;
                    } else if (Math.abs(Math.PI - alpha) < 1.0E-6) {
                        ar = -1.0;
                        ai = 0.0;
                    } else if (Math.abs(1.5707963267948966 - alpha) < 1.0E-6) {
                        ar = 0.0;
                        ai = 1.0;
                    } else if (Math.abs(4.71238898038469 - alpha) < 1.0E-6) {
                        ar = 0.0;
                        ai = -1.0;
                    }
                    this.matrix[i][j] = new Complex(ar / den, -1.0 * ai / den);
                }
                for (int k = 0; k < i; ++k) {
                    this.matrix[i][k] = this.matrix[k][i];
                }
            }
        }
        return this.matrix;
    }

    @Override
    public boolean hasOptimization() {
        return false;
    }
}

