/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.HashMap;
import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.ControlledBlockGate;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Add;
import org.redfx.strange.gate.AddInteger;
import org.redfx.strange.gate.Cnot;
import org.redfx.strange.gate.X;

public class AddModulus
extends BlockGate<AddModulus> {
    Block block;
    static HashMap<Integer, Block> cache = new HashMap();

    public AddModulus(int x0, int x1, int y0, int y1, int N) {
        this.setIndex(x0);
        y1 -= x0;
        y0 -= x0;
        x1 -= x0;
        x0 = 0;
        assert (y0 == x1 + 1);
        int hash = 1000000 * x0 + 10000 * x1 + 100 * y0 + 10 * y1 + N;
        this.block = cache.get(hash);
        if (this.block == null) {
            this.block = this.createBlock(x0, x1, y0, y1, N);
        }
        this.setBlock(this.block);
    }

    public Block createBlock(int x0, int x1, int y0, int y1, int N) {
        Block answer = new Block("AddModulus", y1 - x0 + 2);
        int n = x1 - x0;
        int dim = 2 * (n + 1) + 1;
        Add add = new Add(x0, x1, y0, y1);
        answer.addStep(new Step(add));
        AddInteger min = (AddInteger)new AddInteger(x0, x1, N).inverse();
        answer.addStep(new Step(min));
        answer.addStep(new Step(new Cnot(x1, dim - 1)));
        AddInteger addN = new AddInteger(x0, x1, N);
        ControlledBlockGate cbg = new ControlledBlockGate(addN, x0, dim - 1);
        answer.addStep(new Step(cbg));
        Add add2 = (Add)new Add(x0, x1, y0, y1).inverse();
        answer.addStep(new Step(add2));
        answer.addStep(new Step(new X(dim - 1)));
        Block block = new Block(1);
        block.addStep(new Step(new X(0)));
        ControlledBlockGate cbg2 = new ControlledBlockGate(block, dim - 1, x1);
        answer.addStep(new Step(cbg2));
        Add add3 = new Add(x0, x1, y0, y1);
        answer.addStep(new Step(add3));
        return answer;
    }

    @Override
    public String getCaption() {
        return "A\nD\nD\n";
    }
}

