/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.demo;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.redfx.strange.Complex;
import org.redfx.strange.ControlledBlockGate;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;
import org.redfx.strange.Qubit;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Add;
import org.redfx.strange.gate.AddModulus;
import org.redfx.strange.gate.MulModulus;
import org.redfx.strange.gate.PermutationGate;
import org.redfx.strange.gate.Swap;
import org.redfx.strange.gate.X;
import org.redfx.strange.gate.Y;
import org.redfx.strange.gate.Z;
import org.redfx.strange.local.Computations;
import org.redfx.strange.local.SimpleQuantumExecutionEnvironment;

public class Demo {
    public static void main(String[] args) throws ExecutionException, InterruptedException {
        System.out.println("Hello, Demo3");
        Demo.expmul2p3mod7gen();
        System.err.println("That was the demo");
    }

    private static void mulTest() {
        int s = 1024;
        Complex[][] a = new Complex[s][s];
        Complex[][] b = new Complex[s][s];
        for (int i = 0; i < s; ++i) {
            for (int j = 0; j < s; ++j) {
                a[i][j] = Complex.ONE;
                b[i][j] = Complex.ONE;
            }
        }
        Complex.mmul(a, b);
    }

    private static void memtest() {
        for (int i = 0; i < 100; ++i) {
            int dim = 1 << i;
            System.err.println("\nTry array of " + dim);
            Complex[][] arr = new Complex[dim][dim];
            long fm = Runtime.getRuntime().freeMemory() / 1024L;
            long tm = Runtime.getRuntime().totalMemory() / 1024L;
            long mm = Runtime.getRuntime().maxMemory() / 1024L;
            System.err.println("free: " + fm + "\ntotl: " + tm + "\nused: " + (tm - fm) + "\nmax: " + mm);
            System.gc();
            System.err.println("free: " + fm + "\ntotl: " + tm + "\nused: " + (tm - fm) + "\nmax: " + mm);
        }
    }

    private static void demo1() {
        Program p = new Program(4, new Step[0]);
        Y yGate = new Y(0);
        X xGate = new X(1);
        Z zGate = new Z(3);
        Step step = new Step(new Gate[0]);
        step.addGates(yGate, xGate, zGate);
        p.addStep(step);
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result res = sqee.runProgram(p);
        Qubit[] qubits = res.getQubits();
        Arrays.asList(qubits).forEach(q -> System.out.println(q.measure()));
        Arrays.asList(res.getProbability()).forEach(c -> System.out.println("prob = " + c));
        Complex[][] perm = sqee.createPermutationMatrix(1, 2, 3);
        for (int i = 0; i < perm.length; ++i) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < perm[i].length; ++j) {
                sb.append(perm[i][j]).append("   ");
            }
            System.out.println("sb = " + sb);
        }
        PermutationGate pg = new PermutationGate(0, 2, 3);
        Complex[][] m = pg.getMatrix();
        Demo.printMatrix(m);
    }

    private static void printMatrix(Complex[][] a) {
        for (int i = 0; i < a.length; ++i) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < a[i].length; ++j) {
                sb.append(a[i][j]).append("    ");
            }
            System.out.println("m[" + i + "]: " + sb);
        }
    }

    public static void multiplyMod5x3andswapandclean() {
        Program p = new Program(9, new Step[0]);
        Step prep = new Step(new Gate[0]);
        int mul = 5;
        int N = 6;
        prep.addGates(new X(4), new X(5));
        for (int i = 0; i < mul; ++i) {
            AddModulus add = new AddModulus(0, 3, 4, 7, N);
            p.addStep(new Step(add));
        }
        p.addStep(new Step(new Swap(0, 4)));
        p.addStep(new Step(new Swap(1, 5)));
        p.addStep(new Step(new Swap(2, 6)));
        p.addStep(new Step(new Swap(3, 7)));
        int invsteps = Computations.getInverseModulus(mul, N);
        for (int i = 0; i < invsteps; ++i) {
            AddModulus add = (AddModulus)new AddModulus(0, 3, 4, 7, N).inverse();
            p.addStep(new Step(add));
        }
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result result = sqee.runProgram(p);
        Qubit[] q = result.getQubits();
    }

    public static void expmul3p4mod7() {
        int length = 3;
        int a = 3;
        int mod = 7;
        Program p = new Program(12, new Step[0]);
        Step prep = new Step(new X(2));
        Step prepAnc = new Step(new X(2 * (length + 1)));
        p.addStep(prep);
        p.addStep(prepAnc);
        for (int i = 0; i < length; ++i) {
            int m = (int)Math.pow(a, 1 << i);
            System.err.println("M = " + m);
            MulModulus mul = new MulModulus(length, 2 * length, m, mod);
            ControlledBlockGate cbg = new ControlledBlockGate(mul, length, i);
            p.addStep(new Step(cbg));
        }
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result result = sqee.runProgram(p);
        Qubit[] q = result.getQubits();
        System.err.println("results: ");
        for (int i = 0; i < 12; ++i) {
            System.err.println("m[" + i + "]: " + q[i].measure());
        }
    }

    public static void zerotest() {
        Program p = new Program(2, new Step[0]);
        Step prep = new Step(new Gate[0]);
        prep.addGate(new X(0));
        p.addStep(prep);
        Add add = new Add(0, 0, 1, 1);
        p.addStep(new Step(add));
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result result = sqee.runProgram(p);
        Qubit[] q = result.getQubits();
    }

    public static void modmultest() {
        int length = 3;
        int a = 3;
        int mod = 7;
        Program p = new Program(9, new Step[0]);
        Step prepAnc = new Step(new X(length + 1));
        p.addStep(prepAnc);
        for (int i = 0; i < length; ++i) {
            int m = 1;
            for (int j = 0; j < 1 << i; ++j) {
                m = m * a % mod;
            }
            System.err.println("M = " + m);
            MulModulus mul = new MulModulus(length, 2 * length, m, mod);
            p.addStep(new Step(mul));
        }
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result result = sqee.runProgram(p);
        Qubit[] q = result.getQubits();
        System.err.println("results: ");
        for (int i = 0; i < 9; ++i) {
            System.err.println("m[" + i + "]: " + q[i].measure());
        }
    }

    private static Qubit[] expmod(int a, int mod, int length) {
        Program p = new Program(3 * length, new Step[0]);
        Step prep = new Step(new X(0), new X(1));
        Step prepAnc = new Step(new X(2 * length));
        p.addStep(prep);
        p.addStep(prepAnc);
        for (int i = length - 1; i > -1; --i) {
            int m = 1;
            for (int j = 0; j < 1 << i; ++j) {
                m = m * a % mod;
            }
            System.err.println("M = " + m);
            MulModulus mul = new MulModulus(length, 2 * length - 1, m, mod);
            ControlledBlockGate cbg = new ControlledBlockGate(mul, length, i);
            p.addStep(new Step(cbg));
        }
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result result = sqee.runProgram(p);
        Qubit[] q = result.getQubits();
        return q;
    }

    static void addTest() {
        Program p = new Program(6, new Step[0]);
        Step prep = new Step(new Gate[0]);
        prep.addGates(new X(1), new X(2), new X(3));
        p.addStep(prep);
        Add add = new Add(0, 2, 3, 5);
        p.addStep(new Step(add));
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result result = sqee.runProgram(p);
        Qubit[] q = result.getQubits();
    }

    public static void expmul2p3mod7gen() {
        Qubit[] q = Demo.expmodNum3(2, 7, 3);
        for (int i = 0; i < q.length; ++i) {
            System.err.println("m[" + i + "]: " + q[i].measure());
        }
    }

    public static void expmul7p4mod15gen() {
        Qubit[] q = Demo.expmodNum3(7, 15, 4);
        for (int i = 0; i < q.length; ++i) {
            System.err.println("m[" + i + "]: " + q[i].measure());
        }
    }

    private static Qubit[] expmodNum3(int a, int mod, int length) {
        int offset = 4;
        Program p = new Program(2 * length + 3 + offset, new Step[0]);
        Step prep = new Step(new Gate[0]);
        prep.addGate(new X(0));
        for (int i = 0; i < offset; ++i) {
        }
        Step prepAnc = new Step(new X(length + 1 + offset));
        p.addStep(prep);
        p.addStep(prepAnc);
        for (int i = length - 1; i > length - 1 - offset; --i) {
            int m = 1;
            for (int j = 0; j < 1 << i; ++j) {
                m = m * a % mod;
            }
            System.err.println("i = " + i + ", M = " + m);
            MulModulus mul = new MulModulus(0, length, m, mod);
            ControlledBlockGate cbg = new ControlledBlockGate(mul, offset, length - i - 1);
            p.addStep(new Step(cbg));
        }
        SimpleQuantumExecutionEnvironment sqee = new SimpleQuantumExecutionEnvironment();
        Result result = sqee.runProgram(p);
        Qubit[] q = result.getQubits();
        return q;
    }
}

