/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange;

import java.util.HashMap;
import java.util.Map;
import org.redfx.strange.Complex;
import org.redfx.strange.Qubit;

public class Result {
    private int nqubits;
    private int nsteps;
    private Qubit[] qubits;
    private Complex[] probability;
    private Complex[][] intermediateProps;
    private Map<Integer, Qubit[]> intermediateQubits;
    private int measuredProbability = -1;

    public Result(int nqubits, int steps) {
        assert (steps >= 0);
        this.nqubits = nqubits;
        this.nsteps = steps;
        this.intermediateProps = new Complex[steps > 0 ? steps : 1][];
        this.intermediateQubits = new HashMap<Integer, Qubit[]>();
    }

    public Result(Qubit[] q, Complex[] p) {
        this.qubits = q;
        this.probability = p;
    }

    public Qubit[] getQubits() {
        if (this.qubits == null) {
            this.qubits = this.calculateQubits();
        }
        return this.qubits;
    }

    public Map<Integer, Qubit[]> getIntermediateQubits() {
        return this.intermediateQubits;
    }

    private Qubit[] calculateQubits() {
        Qubit[] answer = new Qubit[this.nqubits];
        if (this.nqubits == 0) {
            return answer;
        }
        int lastidx = this.nsteps - 1;
        while (this.intermediateProps[lastidx] == null) {
            --lastidx;
        }
        double[] d = this.calculateQubitStatesFromVector(this.intermediateProps[lastidx]);
        for (int i = 0; i < answer.length; ++i) {
            answer[i] = new Qubit();
            answer[i].setProbability(d[i]);
        }
        return answer;
    }

    private Qubit[] calculateQubitsFromVector(Complex[] probs) {
        Qubit[] answer = new Qubit[this.nqubits];
        if (this.nqubits == 0) {
            return answer;
        }
        double[] d = this.calculateQubitStatesFromVector(probs);
        for (int i = 0; i < answer.length; ++i) {
            answer[i] = new Qubit();
            answer[i].setProbability(d[i]);
        }
        return answer;
    }

    public Complex[] getProbability() {
        return this.probability;
    }

    public void setIntermediateProbability(int step, Complex[] p) {
        this.intermediateProps[step] = p;
        this.intermediateQubits.put(step, this.calculateQubitsFromVector(p));
        this.probability = p;
    }

    public Complex[] getIntermediateProbability(int step) {
        int ret;
        for (ret = step; ret > 0 && this.intermediateProps[ret] == null; --ret) {
        }
        return this.intermediateProps[ret];
    }

    private double[] calculateQubitStatesFromVector(Complex[] vectorresult) {
        int nq = (int)Math.round(Math.log(vectorresult.length) / Math.log(2.0));
        double[] answer = new double[nq];
        int ressize = 1 << nq;
        for (int i = 0; i < nq; ++i) {
            int pw = i;
            int div = 1 << pw;
            for (int j = 0; j < ressize; ++j) {
                int p1 = j / div;
                if (p1 % 2 != 1) continue;
                answer[i] = answer[i] + vectorresult[j].abssqr();
            }
        }
        return answer;
    }

    public void measureSystem() {
        if (this.qubits == null) {
            this.qubits = this.getQubits();
        }
        double random = Math.random();
        int ressize = 1 << this.nqubits;
        double[] probamp = new double[ressize];
        double probtot = 0.0;
        for (int i = 0; i < ressize; ++i) {
            probamp[i] = this.probability[i].abssqr();
        }
        int sel = 0;
        for (probtot = probamp[0]; probtot < random; probtot += probamp[++sel]) {
        }
        this.measuredProbability = sel;
        double outcome = probamp[sel];
        for (int i = 0; i < this.nqubits; ++i) {
            this.qubits[i].setMeasuredValue(sel % 2 == 1);
            sel /= 2;
        }
    }

    public int getMeasuredProbability() {
        return this.measuredProbability;
    }

    public void printInfo() {
        System.out.println("Info about Quantum Result");
        System.out.println("==========================");
        System.out.println("Number of qubits = " + this.nqubits + ", number of steps = " + this.nsteps);
        for (int i = 0; i < this.probability.length; ++i) {
            System.out.println("Probability on " + i + ":" + this.probability[i].abssqr());
        }
        System.out.println("==========================");
    }
}

