/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Step;
import org.redfx.strange.gate.AddModulus;
import org.redfx.strange.gate.Swap;
import org.redfx.strange.local.Computations;

public class MulModulus
extends BlockGate<MulModulus> {
    Block block;

    public MulModulus(int x0, int x1, int mul, int mod) {
        this.setIndex(x0);
        x1 -= x0;
        x0 = 0;
        this.block = this.createBlock(x0, x1, mul, mod);
        this.setBlock(this.block);
    }

    public Block createBlock(int y0, int y1, int mul, int mod) {
        int i;
        int hash = 1000000 * y0 + 10000 * y1 + 100 * mul + mod;
        int x0 = y0;
        int x1 = y1 - y0;
        int size = 1 + x1 - x0;
        Block answer = new Block("MulModulus", 2 * size + 1);
        for (i = 0; i < mul; ++i) {
            AddModulus add = new AddModulus(x0, x1, x1 + 1, x1 + size, mod);
            answer.addStep(new Step(add));
        }
        for (i = x0; i < x1 + 1; ++i) {
            answer.addStep(new Step(new Swap(i, i + size)));
        }
        int invsteps = Computations.getInverseModulus(mul, mod);
        for (int i2 = 0; i2 < invsteps; ++i2) {
            AddModulus add = (AddModulus)new AddModulus(x0, x1, x1 + 1, x1 + size, mod).inverse();
            answer.addStep(new Step(add));
        }
        return answer;
    }
}

