/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Add;
import org.redfx.strange.gate.Swap;
import org.redfx.strange.local.Computations;

public class Mul
extends BlockGate<Mul> {
    final Block block;

    public Mul(int x0, int x1, int mul) {
        this.setIndex(x0);
        this.idx = x0;
        this.block = this.createBlock(x0, x1, mul);
        this.setBlock(this.block);
    }

    public Block createBlock(int y0, int y1, int mul) {
        int i;
        int x0 = 0;
        int x1 = y1 - y0;
        int size = 1 + x1 - x0;
        int dim = 1 << size;
        Block answer = new Block("Mul", 2 * size);
        for (i = 0; i < mul; ++i) {
            Add add = new Add(x0, x1, x1 + 1, x1 + size);
            answer.addStep(new Step(add));
        }
        for (i = x0; i < x1 + 1; ++i) {
            answer.addStep(new Step(new Swap(i, i + size)));
        }
        int invsteps = Computations.getInverseModulus(mul, dim);
        for (int i2 = 0; i2 < invsteps; ++i2) {
            Add add = (Add)new Add(x0, x1, x1 + 1, x1 + size).inverse();
            answer.addStep(new Step(add));
        }
        return answer;
    }
}

