/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import org.redfx.strange.Complex;
import org.redfx.strange.gate.TwoQubitGate;

public class Cr
extends TwoQubitGate {
    private Complex[][] matrix = new Complex[][]{{Complex.ONE, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ONE, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ONE, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, Complex.ONE.mul(-1.0)}};
    private int pow = -1;

    public Cr() {
    }

    public Cr(int a, int b, double exp) {
        super(a, b);
        double ar = Math.cos(exp);
        double ai = Math.sin(exp);
        if (Math.abs(Math.PI - exp) < 1.0E-6) {
            ar = -1.0;
            ai = 0.0;
        } else if (Math.abs(1.5707963267948966 - exp) < 1.0E-6) {
            ar = 0.0;
            ai = 1.0;
        }
        this.matrix = new Complex[][]{{Complex.ONE, Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ONE, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ONE, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO, new Complex(ar, ai)}};
    }

    public Cr(int a, int b, int base, int pow) {
        this(a, b, Math.PI * 2 / Math.pow(base, pow));
        this.pow = pow;
    }

    @Override
    public Complex[][] getMatrix() {
        return this.matrix;
    }

    @Override
    public void setInverse(boolean inv) {
        if (inv) {
            Complex[][] m = this.getMatrix();
            this.matrix = Complex.conjugateTranspose(m);
        }
    }

    @Override
    public String getCaption() {
        return "Cr" + (this.pow > -1 ? Integer.toString(this.pow) : "th");
    }
}

