/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.HashMap;
import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Fourier;
import org.redfx.strange.gate.InvFourier;
import org.redfx.strange.gate.R;
import org.redfx.strange.gate.SingleQubitMatrixGate;

public class AddInteger
extends BlockGate<AddInteger> {
    Block block;
    static HashMap<Integer, Block> cache = new HashMap();

    public AddInteger(int x0, int x1, int num) {
        this.setIndex(x0);
        x1 -= x0;
        x0 = 0;
        int hash = 1000000 * x0 + 10000 * x1 + num;
        this.block = cache.get(hash);
        if (this.block == null) {
            this.block = this.createBlock(x0, x1, num);
        }
        this.setBlock(this.block);
    }

    public Block createBlock(int x0, int x1, int num) {
        boolean old = false;
        int m = x1 - x0 + 1;
        Block answer = new Block("AddInteger ", m);
        answer.addStep(new Step(new Fourier(m, 0)));
        Step pstep = new Step(new Gate[0]);
        for (int i = 0; i < m; ++i) {
            Complex[][] mat = Complex.identityMatrix(2);
            for (int j = 0; j < m - i; ++j) {
                int cr0 = m - j - i - 1;
                if ((num >> cr0 & 1) != 1) continue;
                mat = Complex.mmul(mat, new R(2, 1 + j, i).getMatrix());
                if (!old) continue;
                Step s = new Step(new R(2, 1 + j, i));
                answer.addStep(s);
            }
            if (old) continue;
            pstep.addGate(new SingleQubitMatrixGate(i, mat));
        }
        if (!old) {
            answer.addStep(pstep);
        }
        answer.addStep(new Step(new InvFourier(m, 0)));
        return answer;
    }
}

