/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.HashMap;
import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Cr;
import org.redfx.strange.gate.Fourier;
import org.redfx.strange.gate.InvFourier;

public class Add
extends BlockGate<Add> {
    Block block;
    static HashMap<Integer, Block> cache = new HashMap();

    public Add(int x0, int x1, int y0, int y1) {
        this.setIndex(x0);
        int hash = 1000000 * x0 + 10000 * x1 + 100 * y0 + y1;
        this.block = cache.get(hash);
        if (this.block == null) {
            this.block = this.createBlock(x0, x1, y0, y1);
        }
        this.setBlock(this.block);
    }

    public Block createBlock(int x0, int x1, int y0, int y1) {
        Block answer = new Block("Add", y1 - x0 + 1);
        int m = x1 - x0 + 1;
        int n = y1 - y0 + 1;
        answer.addStep(new Step(new Fourier(m, 0)));
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m - i; ++j) {
                int cr0 = 2 * m - j - i - 1;
                if (cr0 >= m + n) continue;
                Step s = new Step(new Cr(i, cr0, 2, 1 + j));
                answer.addStep(s);
            }
        }
        answer.addStep(new Step(new InvFourier(m, 0)));
        return answer;
    }
}

