/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange;

import org.redfx.strange.Complex;

public class Qubit {
    private Complex alpha;
    private Complex beta;
    private double theta = 0.0;
    private double phi = 0.0;
    private boolean measured = false;
    private boolean measuredValue;
    private double prob;

    public Qubit() {
        this.alpha = Complex.ONE;
        this.beta = Complex.ZERO;
    }

    public Qubit(double ralpha) {
        this.alpha = new Complex(ralpha, 0.0);
        this.beta = new Complex(Math.sqrt(1.0 - ralpha * ralpha), 0.0);
    }

    private double calculate0() {
        return Math.cos(this.theta / 2.0);
    }

    private Complex calculate1() {
        double s = Math.sin(this.theta / 2.0);
        return new Complex(Math.cos(this.phi) * s, Math.sin(this.phi) * s);
    }

    public void setProbability(double p) {
        this.prob = p;
    }

    public int measure() {
        return this.measuredValue ? 1 : 0;
    }

    public void setMeasuredValue(boolean v) {
        this.measuredValue = v;
    }

    public double getProbability() {
        return this.prob;
    }
}

