/*-
 * #%L
 * Strange
 * %%
 * Copyright (C) 2020 Johan Vos
 * %%
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the Johan Vos nor the names of its contributors
 *    may be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */
package org.redfx.strange.gate;

import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Step;
import static org.redfx.strange.gate.Add.cache;
import java.util.HashMap;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;

/**
 *
 * @author johan
 */
public class AddInteger extends BlockGate<AddInteger> {

    Block block;
    static HashMap<Integer, Block> cache = new HashMap<>();

    
    /**
     * Add the qubit in the x register and the y register, result is in x
     * @param x0 start idx x register
     * @param x1 end idx x register
     * @param num the integer to be added, (y_m.. y_0)
     * x_0 ----- y_0 + x_0
     * x_1 ----- y+1 + x_1
     */
    public AddInteger(int x0, int x1, int num) {
        super();
        setIndex(x0);
        x1 = x1 - x0;
        x0 = 0;
        int hash = 1000000 * x0 + 10000*x1+ num;
        this.block = cache.get(hash);
        if (this.block == null) {
            this.block = createBlock(x0, x1, num);
   //         cache.put(hash, block);
        }
        setBlock(block);
       
    }
    
    public Block createBlock(int x0, int x1, int num) {
        boolean old = false;
        int m = x1-x0+1;
        Block answer = new Block("AddInteger ", m);
        answer.addStep(new Step(new Fourier(m, 0)));
        Step pstep = new Step();
        for (int i = 0; i < m; i++) {
            Complex[][] mat = Complex.identityMatrix(2);
            for (int j = 0; j < m-i ; j++) {
                int cr0 = m-j-i-1;
                if ((num >> cr0 & 1) == 1) {
                    mat = Complex.mmul(mat, new R(2, 1 + j, i).getMatrix());
                    if (old) {
                        Step s = new Step(new R(2, 1 + j, i));
                        answer.addStep(s);
                    }
                }
            }
            if (!old) {
                pstep.addGate(new SingleQubitMatrixGate(i, mat));
            }
        }
        if (!old) {
            answer.addStep(pstep);
        }
        answer.addStep(new Step(new InvFourier(m, 0)));
        return answer;
    }

}
