/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange.gate;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.redfx.strange.Block;
import org.redfx.strange.BlockGate;
import org.redfx.strange.Complex;
import org.redfx.strange.QuantumExecutionEnvironment;

public class Fourier
extends BlockGate {
    protected Complex[][] matrix = null;
    protected int dim;
    protected int size;

    public Fourier(int dim, int idx) {
        this("Fourier", dim, idx);
    }

    public Fourier(String name, int dim, int idx) {
        super(new Block(name, dim), idx);
        this.dim = dim;
        this.size = 1 << dim;
    }

    @Override
    public Complex[][] getMatrix() {
        return this.getMatrix(null);
    }

    @Override
    public Complex[][] getMatrix(QuantumExecutionEnvironment eqq) {
        if (this.matrix == null) {
            double omega = Math.PI * 2 / (double)this.size;
            double den = Math.sqrt(this.size);
            this.matrix = new Complex[this.size][this.size];
            for (int i = 0; i < this.size; ++i) {
                for (int j = i; j < this.size; ++j) {
                    double alpha = omega * (double)i * (double)j;
                    this.matrix[i][j] = new Complex(Math.cos(alpha) / den, Math.sin(alpha) / den);
                }
                for (int k = 0; k < i; ++k) {
                    this.matrix[i][k] = this.matrix[k][i];
                }
            }
        }
        return this.matrix;
    }

    @Override
    public void setInverse(boolean v) {
        if (v) {
            Complex[][] m = this.getMatrix();
            this.matrix = Complex.conjugateTranspose(m);
        }
    }

    public Fourier inverse() {
        Complex[][] m = this.getMatrix();
        this.matrix = Complex.conjugateTranspose(m);
        return this;
    }

    @Override
    public List<Integer> getAffectedQubitIndexes() {
        return IntStream.range(this.idx, this.idx + this.dim).boxed().collect(Collectors.toList());
    }

    @Override
    public int getHighestAffectedQubitIndex() {
        return this.dim + this.idx - 1;
    }

    @Override
    public boolean hasOptimization() {
        return false;
    }
}

