/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.redfx.strange.Gate;
import org.redfx.strange.Program;

public class Step {
    private final ArrayList<Gate> gates = new ArrayList();
    private int index;
    private final String name;
    private Program program;
    private int complexStep = -1;
    private boolean informal = false;

    public Step(Gate ... moreGates) {
        this("unknown", moreGates);
    }

    public Step(String name, Gate ... moreGates) {
        this.name = name;
        this.addGates(moreGates);
    }

    public String getName() {
        return this.name;
    }

    public void addGate(Gate gate) throws IllegalArgumentException {
        this.verifyUnique(Objects.requireNonNull(gate));
        this.gates.add(gate);
    }

    public void addGates(Gate ... moreGates) throws IllegalArgumentException {
        for (Gate g : moreGates) {
            this.addGate(g);
        }
    }

    public List<Gate> getGates() {
        return Collections.unmodifiableList(this.gates);
    }

    public void setComplexStep(int idx) {
        this.complexStep = idx;
    }

    public int getComplexStep() {
        return this.complexStep;
    }

    public void setInformalStep(boolean b) {
        this.informal = b;
    }

    public boolean isInformal() {
        return this.informal;
    }

    public void setIndex(int s) {
        this.index = s;
        this.complexStep = s;
    }

    public int getIndex() {
        return this.index;
    }

    public void setProgram(Program p) {
        this.program = p;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setInverse(boolean val) {
        for (Gate g : this.gates) {
            g.setInverse(val);
        }
    }

    private void verifyUnique(Gate gate) {
        for (Gate g : this.gates) {
            long overlap = g.getAffectedQubitIndexes().stream().filter(gate.getAffectedQubitIndexes()::contains).count();
            if (overlap <= 0L) continue;
            throw new IllegalArgumentException("Adding gate that affects a qubit already involved in this step");
        }
    }

    public String toString() {
        return "Step with gates " + this.gates;
    }
}

