/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.redfx.strange.Gate;
import org.redfx.strange.Result;
import org.redfx.strange.Step;
import org.redfx.strange.gate.Cnot;
import org.redfx.strange.gate.Hadamard;
import org.redfx.strange.gate.Measurement;

public class Program {
    private final int numberQubits;
    private Result result;
    private double[] initAlpha;
    private final ArrayList<Step> steps = new ArrayList();
    private List<Step> decomposedSteps = null;

    public Program(int nQubits, Step ... moreSteps) {
        this.numberQubits = nQubits;
        this.initAlpha = new double[this.numberQubits];
        Arrays.fill(this.initAlpha, 1.0);
        this.addSteps(moreSteps);
    }

    public void initializeQubit(int idx, double alpha) {
        if (idx >= this.numberQubits) {
            throw new IllegalArgumentException("Can not initialize qubit " + idx + " since we have only " + this.numberQubits + " qubits.");
        }
        this.initAlpha[idx] = alpha;
    }

    public double[] getInitialAlphas() {
        return this.initAlpha;
    }

    public void addStep(Step step) {
        if (!this.ensureMeasuresafe(Objects.requireNonNull(step))) {
            throw new IllegalArgumentException("Adding a superposition step to a measured qubit");
        }
        step.setIndex(this.steps.size());
        step.setProgram(this);
        this.steps.add(step);
        this.decomposedSteps = null;
    }

    public void addSteps(Step ... moreSteps) {
        for (Step step : moreSteps) {
            this.addStep(step);
        }
    }

    private boolean ensureMeasuresafe(Step newStep) {
        ArrayList<Integer> mainQubits = new ArrayList<Integer>();
        for (Gate g2 : newStep.getGates()) {
            if (g2 instanceof Hadamard) {
                mainQubits.add(g2.getMainQubitIndex());
                continue;
            }
            if (!(g2 instanceof Cnot)) continue;
            mainQubits.add(((Cnot)g2).getSecondQubitIndex());
        }
        for (Step step : this.getSteps()) {
            boolean match = step.getGates().stream().filter(g -> g instanceof Measurement).map(Gate::getMainQubitIndex).anyMatch(mainQubits::contains);
            if (!match) continue;
            return false;
        }
        return true;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<Step> getDecomposedSteps() {
        return this.decomposedSteps;
    }

    public void setDecomposedSteps(List<Step> ds) {
        this.decomposedSteps = ds;
    }

    public int getNumberQubits() {
        return this.numberQubits;
    }

    public void setResult(Result r) {
        this.result = r;
    }

    public Result getResult() {
        return this.result;
    }

    public void printInfo() {
        System.out.println("Info about Quantum Program");
        System.out.println("==========================");
        System.out.println("Number of qubits = " + this.numberQubits + ", number of steps = " + this.steps.size());
        for (Step step : this.steps) {
            System.out.println("Step: " + step.getGates());
        }
        System.out.println("==========================");
    }
}

