/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange;

import java.util.List;
import org.redfx.strange.Complex;
import org.redfx.strange.QuantumExecutionEnvironment;
import org.redfx.strange.gate.Cnot;
import org.redfx.strange.gate.Cz;
import org.redfx.strange.gate.Hadamard;
import org.redfx.strange.gate.Identity;
import org.redfx.strange.gate.Measurement;
import org.redfx.strange.gate.Oracle;
import org.redfx.strange.gate.PermutationGate;
import org.redfx.strange.gate.ProbabilitiesGate;
import org.redfx.strange.gate.Swap;
import org.redfx.strange.gate.Toffoli;
import org.redfx.strange.gate.X;
import org.redfx.strange.gate.Y;
import org.redfx.strange.gate.Z;

public interface Gate {
    public static Gate cnot(int a, int b) {
        return new Cnot(a, b);
    }

    public static Gate cz(int a, int b) {
        return new Cz(a, b);
    }

    public static Gate hadamard(int idx) {
        return new Hadamard(idx);
    }

    public static Gate identity(int idx) {
        return new Identity(idx);
    }

    public static Gate measurement(int idx) {
        return new Measurement(idx);
    }

    public static Gate oracle(int idx) {
        return new Oracle(idx);
    }

    public static Gate oracle(Complex[][] matrix) {
        return new Oracle(matrix);
    }

    public static Gate permutation(int a, int b, int n) {
        return new PermutationGate(a, b, n);
    }

    public static Gate probability(int idx) {
        return new ProbabilitiesGate(idx);
    }

    public static Gate swap(int a, int b) {
        return new Swap(a, b);
    }

    public static Gate toffoli(int a, int b, int c) {
        return new Toffoli(a, b, c);
    }

    public static Gate x(int idx) {
        return new X(idx);
    }

    public static Gate y(int idx) {
        return new Y(idx);
    }

    public static Gate z(int idx) {
        return new Z(idx);
    }

    public void setMainQubitIndex(int var1);

    public int getMainQubitIndex();

    public void setAdditionalQubit(int var1, int var2);

    public List<Integer> getAffectedQubitIndexes();

    public int getHighestAffectedQubitIndex();

    public String getCaption();

    public String getName();

    public String getGroup();

    public Complex[][] getMatrix();

    public int getSize();

    default public Complex[][] getMatrix(QuantumExecutionEnvironment qee) {
        return this.getMatrix();
    }

    default public boolean hasOptimization() {
        return false;
    }

    default public Complex[] applyOptimize(Complex[] v) {
        return null;
    }

    public void setInverse(boolean var1);
}

