/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.redfx.strange.Block;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;
import org.redfx.strange.QuantumExecutionEnvironment;

public class BlockGate<T extends Gate>
implements Gate {
    protected Block block;
    protected int idx;
    protected boolean inverse = false;

    protected BlockGate() {
    }

    public BlockGate(Block block, int idx) {
        this.block = block;
        this.idx = idx;
    }

    protected final void setBlock(Block b) {
        this.block = b;
    }

    public final Block getBlock() {
        return this.block;
    }

    protected final void setIndex(int idx) {
        this.idx = idx;
    }

    @Override
    public void setMainQubitIndex(int idx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMainQubitIndex() {
        return this.idx;
    }

    @Override
    public void setAdditionalQubit(int idx, int cnt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Integer> getAffectedQubitIndexes() {
        return IntStream.range(this.idx, this.idx + this.block.getNQubits()).boxed().collect(Collectors.toList());
    }

    @Override
    public int getHighestAffectedQubitIndex() {
        int answer = this.block.getNQubits() + this.idx - 1;
        return answer;
    }

    @Override
    public String getCaption() {
        return "B";
    }

    @Override
    public String getName() {
        return "BlockGate";
    }

    @Override
    public String getGroup() {
        return "BlockGroup";
    }

    @Override
    public Complex[][] getMatrix() {
        return this.getMatrix(null);
    }

    @Override
    public Complex[][] getMatrix(QuantumExecutionEnvironment qee) {
        Complex[][] answer = this.block.getMatrix(qee);
        if (this.inverse) {
            answer = Complex.conjugateTranspose(answer);
            Complex.printMatrix(answer);
        }
        return answer;
    }

    @Override
    public void setInverse(boolean inv) {
        this.inverse = inv;
    }

    public T inverse() {
        this.setInverse(true);
        return (T)this;
    }

    @Override
    public int getSize() {
        return this.block.getNQubits();
    }

    @Override
    public boolean hasOptimization() {
        return true;
    }

    @Override
    public Complex[] applyOptimize(Complex[] v) {
        return this.block.applyOptimize(v, this.inverse);
    }

    public String toString() {
        return "Gate for block " + this.block + ", size = " + this.getSize() + ", inv = " + this.inverse;
    }
}

