/*
 * Decompiled with CFR 0.152.
 */
package org.redfx.strange;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.redfx.strange.Complex;
import org.redfx.strange.Gate;
import org.redfx.strange.QuantumExecutionEnvironment;
import org.redfx.strange.Step;
import org.redfx.strange.gate.PermutationGate;
import org.redfx.strange.gate.ProbabilitiesGate;
import org.redfx.strange.local.Computations;

public class Block {
    List<Step> steps = new ArrayList<Step>();
    private final int nqubits;
    private Complex[][] matrix = null;
    private final String name;

    public Block(int size) {
        this("anonymous", size);
    }

    public Block(String name, int size) {
        this.nqubits = size;
        this.name = name;
    }

    public void addStep(Step step) {
        this.steps.add(step);
        this.matrix = null;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public int getNQubits() {
        return this.nqubits;
    }

    private void validateGate(Gate gate) {
        gate.getAffectedQubitIndexes().stream().filter(idx -> idx > this.nqubits - 1).forEachOrdered(item -> {
            throw new IllegalArgumentException("Can't add a gate with qubit index larger than block size");
        });
    }

    Complex[][] getMatrix() {
        return this.getMatrix(null);
    }

    Complex[][] getMatrix(QuantumExecutionEnvironment qee) {
        if (this.matrix == null) {
            this.matrix = Complex.identityMatrix(1 << this.nqubits);
            ArrayList<Step> simpleSteps = new ArrayList<Step>();
            for (Step step : this.steps) {
                simpleSteps.addAll(Computations.decomposeStep(step, this.nqubits));
            }
            Collections.reverse(simpleSteps);
            for (Step step : simpleSteps) {
                List<Gate> gates = step.getGates();
                if (this.matrix != null && gates.size() == 1 && gates.get(0) instanceof PermutationGate) {
                    this.matrix = Complex.permutate((PermutationGate)gates.get(0), this.matrix);
                    continue;
                }
                Complex[][] m = Computations.calculateStepMatrix(step.getGates(), this.nqubits, qee);
                if (this.matrix == null) {
                    this.matrix = m;
                    continue;
                }
                if (qee != null) {
                    this.matrix = qee.mmul(this.matrix, m);
                    continue;
                }
                this.matrix = Complex.mmul(this.matrix, m);
            }
        }
        return this.matrix;
    }

    public Complex[] applyOptimize(Complex[] probs, boolean inverse) {
        int dim = probs.length;
        ArrayList<Step> simpleSteps = new ArrayList<Step>();
        for (Step step : this.steps) {
            simpleSteps.addAll(Computations.decomposeStep(step, this.nqubits));
        }
        if (inverse) {
            Collections.reverse(simpleSteps);
            for (Step step : simpleSteps) {
                step.setInverse(true);
            }
        }
        for (Step step : simpleSteps) {
            if (step.getGates().isEmpty()) continue;
            probs = this.applyStep(step, probs);
        }
        return probs;
    }

    private Complex[] applyStep(Step step, Complex[] vector) {
        long s0 = System.currentTimeMillis();
        List<Gate> gates = step.getGates();
        if (!gates.isEmpty() && gates.get(0) instanceof ProbabilitiesGate) {
            return vector;
        }
        if (gates.size() == 1 && gates.get(0) instanceof PermutationGate) {
            PermutationGate pg = (PermutationGate)gates.get(0);
            return Computations.permutateVector(vector, pg.getIndex1(), pg.getIndex2());
        }
        Complex[] result = new Complex[vector.length];
        result = Computations.calculateNewState(gates, vector, this.nqubits);
        long s1 = System.currentTimeMillis();
        return result;
    }

    public String toString() {
        return "Block named " + this.name + " at " + super.toString();
    }
}

