/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.IAudioStreamCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioCodecFactory {
    public static final String KEY = "audioCodecFactory";
    private static Logger log = LoggerFactory.getLogger(AudioCodecFactory.class);
    private static List<IAudioStreamCodec> codecs = new ArrayList<IAudioStreamCodec>(1);

    public void setCodecs(List<IAudioStreamCodec> codecs) {
        AudioCodecFactory.codecs = codecs;
    }

    public static IAudioStreamCodec getAudioCodec(IoBuffer data) {
        IAudioStreamCodec result = null;
        try {
            int codecId = (data.get() & 0xF0) >> 4;
            switch (codecId) {
                case 10: {
                    result = (IAudioStreamCodec)Class.forName("org.red5.codec.AACAudio").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 11: {
                    result = (IAudioStreamCodec)Class.forName("org.red5.codec.SpeexAudio").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break;
                }
                case 2: 
                case 14: {
                    result = (IAudioStreamCodec)Class.forName("org.red5.codec.MP3Audio").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            data.rewind();
        }
        catch (Exception ex) {
            log.error("Error creating codec instance", (Throwable)ex);
        }
        if (result == null) {
            for (IAudioStreamCodec storedCodec : codecs) {
                IAudioStreamCodec codec;
                try {
                    codec = (IAudioStreamCodec)storedCodec.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    log.error("Could not create audio codec instance", (Throwable)e);
                    continue;
                }
                if (!codec.canHandleData(data)) continue;
                result = codec;
                break;
            }
        }
        return result;
    }
}

