/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scope;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.server.api.IConnection;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeSecurityHandler;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicScope
implements IBasicScope,
Comparable<BasicScope> {
    protected static Logger log = LoggerFactory.getLogger(BasicScope.class);
    private String keepAliveJobName;
    protected IScope parent;
    protected ScopeType type = ScopeType.UNDEFINED;
    protected String name;
    protected long creation;
    protected boolean persistent;
    protected IPersistenceStore store;
    protected String persistenceClass;
    protected boolean keepOnDisconnect;
    protected int keepDelay = 0;
    protected transient CopyOnWriteArraySet<IScopeSecurityHandler> securityHandlers;
    protected transient CopyOnWriteArraySet<IEventListener> listeners;

    @ConstructorProperties(value={""})
    public BasicScope() {
        this.creation = System.nanoTime();
    }

    @ConstructorProperties(value={"parent", "type", "name", "persistent"})
    public BasicScope(IScope parent, ScopeType type, String name, boolean persistent) {
        this.parent = parent;
        this.type = type;
        this.name = name;
        this.persistent = persistent;
        this.listeners = new CopyOnWriteArraySet();
        this.creation = System.nanoTime();
    }

    @Override
    public boolean hasParent() {
        return true;
    }

    @Override
    public IScope getParent() {
        return this.parent;
    }

    @Override
    public ScopeType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IPersistenceStore getStore() {
        return this.store;
    }

    @Override
    public int getDepth() {
        return this.parent.getDepth() + 1;
    }

    @Override
    public String getPath() {
        return String.format("%s/%s", this.parent.getPath(), this.parent.getName());
    }

    @Override
    public void setKeepDelay(int keepDelay) {
        this.keepDelay = keepDelay;
    }

    @Override
    public boolean isValid() {
        return this.type != null && !this.type.equals((Object)ScopeType.UNDEFINED) && this.name != null && !"".equals(this.name);
    }

    @Override
    public boolean isConnectionAllowed(IConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug("isConnectionAllowed: {}", (Object)conn);
        }
        if (this.securityHandlers != null) {
            if (log.isDebugEnabled()) {
                log.debug("securityHandlers: {}", this.securityHandlers);
            }
            for (IScopeSecurityHandler handler : this.securityHandlers) {
                if (handler.allowed(conn)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isScopeAllowed(IScope scope) {
        if (log.isDebugEnabled()) {
            log.debug("isScopeAllowed: {}", (Object)scope);
        }
        if (this.securityHandlers != null) {
            for (IScopeSecurityHandler handler : this.securityHandlers) {
                if (handler.allowed(scope)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setSecurityHandlers(Set<IScopeSecurityHandler> handlers) {
        if (this.securityHandlers == null) {
            this.securityHandlers = new CopyOnWriteArraySet();
        }
        this.securityHandlers.addAll(handlers);
        if (log.isDebugEnabled()) {
            log.debug("securityHandlers: {}", this.securityHandlers);
        }
    }

    @Override
    public boolean addEventListener(IEventListener listener) {
        log.debug("addEventListener - scope: {} {}", (Object)this.getName(), (Object)listener);
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeEventListener(IEventListener listener) {
        log.debug("removeEventListener - scope: {} {}", (Object)this.getName(), (Object)listener);
        if (log.isTraceEnabled()) {
            log.trace("Listeners - check #1: {}", this.listeners);
        }
        boolean removed = this.listeners.remove(listener);
        if (!this.keepOnDisconnect) {
            if (removed && this.keepAliveJobName == null && ScopeUtils.isRoom(this) && this.listeners.isEmpty()) {
                ISchedulingService schedulingService = (ISchedulingService)this.parent.getContext().getBean("schedulingService");
                this.keepAliveJobName = schedulingService.addScheduledOnceJob(this.keepDelay > 0 ? this.keepDelay * 1000 : 100, (IScheduledJob)new KeepAliveJob(this));
            }
        } else {
            log.trace("Scope: {} is exempt from removal when empty", (Object)this.getName());
        }
        if (log.isTraceEnabled()) {
            log.trace("Listeners - check #2: {}", this.listeners);
        }
        return removed;
    }

    @Override
    public Set<IEventListener> getEventListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public boolean hasEventListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public boolean handleEvent(IEvent event) {
        return false;
    }

    @Override
    public void notifyEvent(IEvent event) {
    }

    @Override
    public void dispatchEvent(IEvent event) {
        for (IEventListener listener : this.listeners) {
            if (event.getSource() != null && event.getSource() == listener) continue;
            listener.notifyEvent(event);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicScope other = (BasicScope)obj;
        return this.hashCode() == other.hashCode();
    }

    @Override
    public int compareTo(BasicScope that) {
        if (this.equals(that)) {
            return 0;
        }
        int c = this.name.compareTo(that.getName());
        if (c == 0 && (c = this.type.compareTo(that.getType())) == 0) {
            c = this.getPath().compareTo(that.getPath());
        }
        return c;
    }

    private class KeepAliveJob
    implements IScheduledJob {
        private final IBasicScope scope;

        KeepAliveJob(IBasicScope scope) {
            this.scope = scope;
        }

        @Override
        public void execute(ISchedulingService service) {
            if (BasicScope.this.listeners.isEmpty()) {
                log.trace("Removing {} from {}", (Object)this.scope.getName(), (Object)BasicScope.this.parent.getName());
                BasicScope.this.parent.removeChildScope(this.scope);
            }
            BasicScope.this.keepAliveJobName = null;
        }
    }
}

