/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.protocol;

public class RTMPDecodeState {
    public static byte DECODER_OK = 0;
    public static byte DECODER_CONTINUE = 1;
    public static byte DECODER_BUFFER = (byte)2;
    public final String sessionId;
    private int decoderBufferAmount;
    private byte decoderState = DECODER_OK;
    private static final String[] names = new String[]{"Ok", "Continue", "Buffer"};

    public RTMPDecodeState(String sessionId) {
        this.sessionId = sessionId;
    }

    public int getDecoderBufferAmount() {
        return this.decoderBufferAmount;
    }

    public void bufferDecoding(int amount) {
        this.decoderState = DECODER_BUFFER;
        this.decoderBufferAmount = amount;
    }

    public void continueDecoding() {
        this.decoderState = DECODER_CONTINUE;
    }

    public boolean canStartDecoding(int remaining) {
        return remaining >= this.decoderBufferAmount;
    }

    public void startDecoding() {
        this.decoderState = DECODER_OK;
        this.decoderBufferAmount = 0;
    }

    public boolean hasDecodedObject() {
        return this.decoderState == DECODER_OK;
    }

    public boolean canContinueDecoding() {
        return this.decoderState != DECODER_BUFFER;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return "RTMPDecodeState [sessionId=" + this.sessionId + ", decoderState=" + names[this.decoderState] + ", decoderBufferAmount=" + this.decoderBufferAmount + "]";
    }
}

