/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.sctp.packet;

import java.nio.ByteBuffer;
import org.red5.io.sctp.SctpException;

public final class SctpHeader {
    private int sourcePort;
    private int destinationPort;
    private int verificationTag;
    private int checksum;
    private static final int HEADER_SIZE = 12;

    public SctpHeader(int sourcePort, int destinationPort, int verificationTag, int checksum) {
        this.sourcePort = sourcePort;
        this.destinationPort = destinationPort;
        this.verificationTag = verificationTag;
        this.checksum = checksum;
    }

    public SctpHeader(byte[] data, int offset, int length) throws SctpException {
        if (length < 12) {
            throw new SctpException("not enough data for parsing Sctp header : " + data);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, offset, 12);
        this.sourcePort = byteBuffer.getShort() & 0xFFFF;
        this.destinationPort = byteBuffer.getShort() & 0xFFFF;
        this.verificationTag = byteBuffer.getInt();
        this.checksum = byteBuffer.getInt();
    }

    public int getSize() {
        return 12;
    }

    public byte[] getBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        byteBuffer.putShort((short)this.getSourcePort());
        byteBuffer.putShort((short)this.getDestinationPort());
        byteBuffer.putInt(this.getVerificationTag());
        byteBuffer.putInt(this.checksum);
        return byteBuffer.array();
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public int getVerificationTag() {
        return this.verificationTag;
    }
}

