/*
 * Decompiled with CFR 0.152.
 */
package org.red5.cache.impl;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.cache.ICacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableImpl
implements ICacheable {
    private static final long serialVersionUID = 1539954562379472856L;
    protected static Logger log = LoggerFactory.getLogger(CacheableImpl.class);
    private byte[] bytes;
    private String name;
    private boolean cached;

    public CacheableImpl(Object obj) {
        IoBuffer tmp = IoBuffer.allocate((int)128).setAutoExpand(true);
        tmp.putObject(obj);
        tmp.flip();
        this.bytes = new byte[tmp.remaining()];
        tmp.get(this.bytes);
        this.cached = true;
        tmp.free();
        tmp = null;
    }

    public CacheableImpl(IoBuffer buffer) {
        if (log.isDebugEnabled()) {
            log.debug("Buffer is direct: {} capacity: {}", (Object)buffer.isDirect(), (Object)buffer.capacity());
            log.debug("Buffer limit: {} remaining: {} position: {}", new Object[]{buffer.limit(), buffer.remaining(), buffer.position()});
        }
        this.bytes = new byte[buffer.remaining()];
        buffer.rewind();
        buffer.get(this.bytes);
        this.cached = true;
        if (log.isDebugEnabled()) {
            log.debug("Buffer size: {}", (Object)buffer.capacity());
        }
        buffer = null;
    }

    public void addRequest() {
        log.info("Adding request for: {}", (Object)this.name);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public IoBuffer getByteBuffer() {
        return IoBuffer.wrap((byte[])this.bytes).asReadOnlyBuffer();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    @Override
    public void setCached(boolean cached) {
        this.cached = cached;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

