/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.pdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Locator;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.shared.publication.services.PositionsService;
import org.readium.r2.shared.util.Url;
import org.readium.r2.shared.util.mediatype.MediaType;
import timber.log.Timber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u0007H\u0096@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService;", "Lorg/readium/r2/shared/publication/services/PositionsService;", "link", "Lorg/readium/r2/shared/publication/Link;", "pageCount", "", "tableOfContents", "", "<init>", "(Lorg/readium/r2/shared/publication/Link;ILjava/util/List;)V", "positionsByReadingOrder", "Lorg/readium/r2/shared/publication/Locator;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "_positions", "get_positions", "()Ljava/util/List;", "_positions$delegate", "Lkotlin/Lazy;", "Companion", "readium-streamer_release"})
@SourceDebugExtension(value={"SMAP\nPdfPositionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfPositionsService.kt\norg/readium/r2/streamer/parser/pdf/PdfPositionsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1563#2:74\n1634#2,3:75\n*S KotlinDebug\n*F\n+ 1 PdfPositionsService.kt\norg/readium/r2/streamer/parser/pdf/PdfPositionsService\n*L\n44#1:74\n44#1:75,3\n*E\n"})
public final class PdfPositionsService
implements PositionsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Link link;
    private final int pageCount;
    @NotNull
    private final List<Link> tableOfContents;
    @NotNull
    private final Lazy _positions$delegate;

    public PdfPositionsService(@NotNull Link link, int pageCount, @NotNull List<Link> tableOfContents) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter(tableOfContents, (String)"tableOfContents");
        this.link = link;
        this.pageCount = pageCount;
        this.tableOfContents = tableOfContents;
        this._positions$delegate = LazyKt.lazy(() -> PdfPositionsService._positions_delegate$lambda$1(this));
    }

    @Nullable
    public Object positionsByReadingOrder(@NotNull Continuation<? super List<? extends List<Locator>>> $completion) {
        return this.get_positions();
    }

    private final List<List<Locator>> get_positions() {
        Lazy lazy = this._positions$delegate;
        return (List)lazy.getValue();
    }

    @Nullable
    public Object positions(@NotNull Continuation<? super List<Locator>> $completion) {
        return PositionsService.DefaultImpls.positions((PositionsService)this, $completion);
    }

    public void close() {
        PositionsService.DefaultImpls.close((PositionsService)this);
    }

    /*
     * WARNING - void declaration
     */
    private static final List _positions_delegate$lambda$1(PdfPositionsService this$0) {
        void $this$mapTo$iv$iv;
        if (this$0.pageCount <= 0) {
            Timber.Forest.e("Invalid page count for a PDF document: " + this$0.pageCount, new Object[0]);
            return CollectionsKt.listOf((Object)CollectionsKt.emptyList());
        }
        Url href = Link.url$default((Link)this$0.link, null, null, (int)3, null);
        Iterable $this$map$iv = (Iterable)new IntRange(1, this$0.pageCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void position;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double progression = (double)(position - true) / (double)this$0.pageCount;
            MediaType mediaType = this$0.link.getMediaType();
            if (mediaType == null) {
                mediaType = MediaType.Companion.getPDF();
            }
            List list = CollectionsKt.listOf((Object)("page=" + (int)position));
            collection.add(new Locator(href, mediaType, null, new Locator.Locations(list, Double.valueOf(progression), Integer.valueOf((int)position), Double.valueOf(progression), null, 16, null), null, 20, null));
        }
        return CollectionsKt.listOf((Object)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService$Companion;", "", "<init>", "()V", "create", "Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService;", "context", "Lorg/readium/r2/shared/publication/Publication$Service$Context;", "readium-streamer_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PdfPositionsService create(@NotNull Publication.Service.Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Link link = (Link)CollectionsKt.firstOrNull((List)context.getManifest().getReadingOrder());
            if (link == null) {
                return null;
            }
            Link link2 = link;
            Integer n = context.getManifest().getMetadata().getNumberOfPages();
            return new PdfPositionsService(link2, n != null ? n : 0, context.getManifest().getTableOfContents());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

