/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.util.Url;
import org.readium.r2.shared.util.xml.ElementNode;
import org.readium.r2.streamer.parser.epub.Guide;
import org.readium.r2.streamer.parser.epub.Item;
import org.readium.r2.streamer.parser.epub.MetadataItem;
import org.readium.r2.streamer.parser.epub.MetadataParser;
import org.readium.r2.streamer.parser.epub.PropertyDataTypeKt;
import org.readium.r2.streamer.parser.epub.Spine;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 -2\u00020\u0001:\u0001-BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u000eH\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u00c6\u0003Jc\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006."}, d2={"Lorg/readium/r2/streamer/parser/epub/PackageDocument;", "", "path", "Lorg/readium/r2/shared/util/Url;", "epubVersion", "", "uniqueIdentifierId", "", "metadata", "", "Lorg/readium/r2/streamer/parser/epub/MetadataItem;", "manifest", "Lorg/readium/r2/streamer/parser/epub/Item;", "spine", "Lorg/readium/r2/streamer/parser/epub/Spine;", "guide", "Lorg/readium/r2/shared/publication/Link;", "<init>", "(Lorg/readium/r2/shared/util/Url;DLjava/lang/String;Ljava/util/List;Ljava/util/List;Lorg/readium/r2/streamer/parser/epub/Spine;Ljava/util/List;)V", "getPath", "()Lorg/readium/r2/shared/util/Url;", "getEpubVersion", "()D", "getUniqueIdentifierId", "()Ljava/lang/String;", "getMetadata", "()Ljava/util/List;", "getManifest", "getSpine", "()Lorg/readium/r2/streamer/parser/epub/Spine;", "getGuide", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "readium-streamer_release"})
public final class PackageDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Url path;
    private final double epubVersion;
    @Nullable
    private final String uniqueIdentifierId;
    @NotNull
    private final List<MetadataItem> metadata;
    @NotNull
    private final List<Item> manifest;
    @NotNull
    private final Spine spine;
    @NotNull
    private final List<Link> guide;

    public PackageDocument(@NotNull Url path, double epubVersion, @Nullable String uniqueIdentifierId, @NotNull List<? extends MetadataItem> metadata, @NotNull List<Item> manifest, @NotNull Spine spine, @NotNull List<Link> guide) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter((Object)spine, (String)"spine");
        Intrinsics.checkNotNullParameter(guide, (String)"guide");
        this.path = path;
        this.epubVersion = epubVersion;
        this.uniqueIdentifierId = uniqueIdentifierId;
        this.metadata = metadata;
        this.manifest = manifest;
        this.spine = spine;
        this.guide = guide;
    }

    @NotNull
    public final Url getPath() {
        return this.path;
    }

    public final double getEpubVersion() {
        return this.epubVersion;
    }

    @Nullable
    public final String getUniqueIdentifierId() {
        return this.uniqueIdentifierId;
    }

    @NotNull
    public final List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final List<Item> getManifest() {
        return this.manifest;
    }

    @NotNull
    public final Spine getSpine() {
        return this.spine;
    }

    @NotNull
    public final List<Link> getGuide() {
        return this.guide;
    }

    @NotNull
    public final Url component1() {
        return this.path;
    }

    public final double component2() {
        return this.epubVersion;
    }

    @Nullable
    public final String component3() {
        return this.uniqueIdentifierId;
    }

    @NotNull
    public final List<MetadataItem> component4() {
        return this.metadata;
    }

    @NotNull
    public final List<Item> component5() {
        return this.manifest;
    }

    @NotNull
    public final Spine component6() {
        return this.spine;
    }

    @NotNull
    public final List<Link> component7() {
        return this.guide;
    }

    @NotNull
    public final PackageDocument copy(@NotNull Url path, double epubVersion, @Nullable String uniqueIdentifierId, @NotNull List<? extends MetadataItem> metadata, @NotNull List<Item> manifest, @NotNull Spine spine, @NotNull List<Link> guide) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter((Object)spine, (String)"spine");
        Intrinsics.checkNotNullParameter(guide, (String)"guide");
        return new PackageDocument(path, epubVersion, uniqueIdentifierId, metadata, manifest, spine, guide);
    }

    public static /* synthetic */ PackageDocument copy$default(PackageDocument packageDocument, Url url, double d, String string, List list, List list2, Spine spine, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            url = packageDocument.path;
        }
        if ((n & 2) != 0) {
            d = packageDocument.epubVersion;
        }
        if ((n & 4) != 0) {
            string = packageDocument.uniqueIdentifierId;
        }
        if ((n & 8) != 0) {
            list = packageDocument.metadata;
        }
        if ((n & 0x10) != 0) {
            list2 = packageDocument.manifest;
        }
        if ((n & 0x20) != 0) {
            spine = packageDocument.spine;
        }
        if ((n & 0x40) != 0) {
            list3 = packageDocument.guide;
        }
        return packageDocument.copy(url, d, string, list, list2, spine, list3);
    }

    @NotNull
    public String toString() {
        return "PackageDocument(path=" + this.path + ", epubVersion=" + this.epubVersion + ", uniqueIdentifierId=" + this.uniqueIdentifierId + ", metadata=" + this.metadata + ", manifest=" + this.manifest + ", spine=" + this.spine + ", guide=" + this.guide + ')';
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + Double.hashCode(this.epubVersion);
        result = result * 31 + (this.uniqueIdentifierId == null ? 0 : this.uniqueIdentifierId.hashCode());
        result = result * 31 + ((Object)this.metadata).hashCode();
        result = result * 31 + ((Object)this.manifest).hashCode();
        result = result * 31 + this.spine.hashCode();
        result = result * 31 + ((Object)this.guide).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackageDocument)) {
            return false;
        }
        PackageDocument packageDocument = (PackageDocument)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)packageDocument.path)) {
            return false;
        }
        if (Double.compare(this.epubVersion, packageDocument.epubVersion) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.uniqueIdentifierId, (Object)packageDocument.uniqueIdentifierId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.metadata, packageDocument.metadata)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.manifest, packageDocument.manifest)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spine, (Object)packageDocument.spine)) {
            return false;
        }
        return Intrinsics.areEqual(this.guide, packageDocument.guide);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/readium/r2/streamer/parser/epub/PackageDocument$Companion;", "", "<init>", "()V", "parse", "Lorg/readium/r2/streamer/parser/epub/PackageDocument;", "document", "Lorg/readium/r2/shared/util/xml/ElementNode;", "filePath", "Lorg/readium/r2/shared/util/Url;", "readium-streamer_release"})
    @SourceDebugExtension(value={"SMAP\nPackageDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageDocument.kt\norg/readium/r2/streamer/parser/epub/PackageDocument$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1#2:170\n1#2:181\n1617#3,9:171\n1869#3:180\n1870#3:182\n1626#3:183\n*S KotlinDebug\n*F\n+ 1 PackageDocument.kt\norg/readium/r2/streamer/parser/epub/PackageDocument$Companion\n*L\n47#1:181\n47#1:171,9\n47#1:180\n47#1:182\n47#1:183\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PackageDocument parse(@NotNull ElementNode document, @NotNull Url filePath) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Map map;
            Map map2;
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            String string = document.getAttr("prefix");
            if (string != null) {
                String it = string;
                boolean bl = false;
                map2 = PropertyDataTypeKt.parsePrefixes(it);
            } else {
                map2 = map = null;
            }
            if (map2 == null) {
                map = MapsKt.emptyMap();
            }
            Map packagePrefixes = map;
            Map prefixMap = MapsKt.plus(PropertyDataTypeKt.getPACKAGE_RESERVED_PREFIXES(), (Map)packagePrefixes);
            Object object = document.getAttr("version");
            double epubVersion = object != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? (Double)object : 1.2;
            List<MetadataItem> list = new MetadataParser(prefixMap).parse(document, filePath);
            if (list == null) {
                return null;
            }
            List<MetadataItem> metadata = list;
            ElementNode elementNode = document.getFirst("manifest", "http://www.idpf.org/2007/opf");
            if (elementNode == null) {
                return null;
            }
            ElementNode manifestElement = elementNode;
            ElementNode elementNode2 = document.getFirst("spine", "http://www.idpf.org/2007/opf");
            if (elementNode2 == null) {
                return null;
            }
            ElementNode spineElement = elementNode2;
            ElementNode guideElement = document.getFirst("guide", "http://www.idpf.org/2007/opf");
            Iterable iterable = manifestElement.get("item", "http://www.idpf.org/2007/opf");
            List<MetadataItem> list2 = metadata;
            String string2 = document.getAttr("unique-identifier");
            double d = epubVersion;
            Url url = filePath;
            boolean $i$f$mapNotNull = false;
            void var13_18 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Item it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ElementNode it = (ElementNode)element$iv$iv;
                boolean bl2 = false;
                if (Item.Companion.parse(it, filePath, prefixMap) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            List<Link> list4 = Guide.Companion.parse(guideElement, filePath, prefixMap);
            Spine spine = Spine.Companion.parse(spineElement, prefixMap, epubVersion);
            List list5 = list3;
            List<MetadataItem> list6 = list2;
            String string3 = string2;
            double d2 = d;
            Url url2 = url;
            return new PackageDocument(url2, d2, string3, list6, list5, spine, list4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

