/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.publication.encryption.Encryption;
import org.readium.r2.shared.util.Try;
import org.readium.r2.shared.util.Url;
import org.readium.r2.shared.util.UrlKt;
import org.readium.r2.shared.util.data.ReadError;
import org.readium.r2.shared.util.resource.LazyResourceKt;
import org.readium.r2.shared.util.resource.Resource;
import org.readium.r2.shared.util.resource.TransformingResource;
import org.readium.r2.streamer.extensions.StringExtKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000bJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/readium/r2/streamer/parser/epub/EpubDeobfuscator;", "", "pubId", "", "encryptionData", "", "Lorg/readium/r2/shared/util/Url;", "Lorg/readium/r2/shared/publication/encryption/Encryption;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "transform", "Lorg/readium/r2/shared/util/resource/Resource;", "url", "resource", "algorithm2length", "", "deobfuscate", "", "bytes", "", "obfuscationKey", "obfuscationLength", "getHashKeyAdobe", "DeobfuscatingResource", "readium-streamer_release"})
public final class EpubDeobfuscator {
    @NotNull
    private final String pubId;
    @NotNull
    private final Map<Url, Encryption> encryptionData;
    @NotNull
    private final Map<String, Integer> algorithm2length;

    public EpubDeobfuscator(@NotNull String pubId, @NotNull Map<Url, Encryption> encryptionData) {
        Intrinsics.checkNotNullParameter((Object)pubId, (String)"pubId");
        Intrinsics.checkNotNullParameter(encryptionData, (String)"encryptionData");
        this.pubId = pubId;
        this.encryptionData = encryptionData;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"http://www.idpf.org/2008/embedding", (Object)1040), TuplesKt.to((Object)"http://ns.adobe.com/pdf/enc#RC", (Object)1024)};
        this.algorithm2length = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final Resource transform(@NotNull Url url, @NotNull Resource resource) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return (Resource)LazyResourceKt.flatMap((Resource)resource, (Function2)((Function2)new Function2<Resource, Continuation<? super Resource>, Object>(this, url, resource, null){
            int label;
            final /* synthetic */ EpubDeobfuscator this$0;
            final /* synthetic */ Url $url;
            final /* synthetic */ Resource $resource;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                this.$resource = $resource;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Encryption encryption = (Encryption)UrlKt.getEquivalent((Map)EpubDeobfuscator.access$getEncryptionData$p(this.this$0), (Url)this.$url);
                        String algorithm = encryption != null ? encryption.getAlgorithm() : null;
                        return algorithm != null && EpubDeobfuscator.access$getAlgorithm2length$p(this.this$0).containsKey(algorithm) ? (Resource)this.this$0.new DeobfuscatingResource(this.$resource, algorithm) : this.$resource;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Resource p1, Continuation<? super Resource> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void deobfuscate(byte[] bytes, byte[] obfuscationKey, int obfuscationLength) {
        int n;
        IntRange toDeobfuscate = RangesKt.until((int)0, (int)RangesKt.coerceAtMost((int)obfuscationLength, (int)bytes.length));
        int i = toDeobfuscate.getFirst();
        if (i <= (n = toDeobfuscate.getLast())) {
            while (true) {
                bytes[i] = (byte)(bytes[i] ^ obfuscationKey[i % obfuscationKey.length]);
                if (i == n) break;
                ++i;
            }
        }
    }

    private final String getHashKeyAdobe(String pubId) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)pubId, (String)"urn:uuid:", (String)"", (boolean)false, (int)4, null), (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ Map access$getEncryptionData$p(EpubDeobfuscator $this) {
        return $this.encryptionData;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\b\u0012\u0004\u0012\u00020\n`\fH\u0096@\u00a2\u0006\u0002\u0010\rJB\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\tj\b\u0012\u0004\u0012\u00020\u000f`\f2\u001c\u0010\u0010\u001a\u0018\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\tj\b\u0012\u0004\u0012\u00020\u000f`\fH\u0096@\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/streamer/parser/epub/EpubDeobfuscator$DeobfuscatingResource;", "Lorg/readium/r2/shared/util/resource/TransformingResource;", "resource", "Lorg/readium/r2/shared/util/resource/Resource;", "algorithm", "", "<init>", "(Lorg/readium/r2/streamer/parser/epub/EpubDeobfuscator;Lorg/readium/r2/shared/util/resource/Resource;Ljava/lang/String;)V", "length", "Lorg/readium/r2/shared/util/Try;", "", "Lorg/readium/r2/shared/util/data/ReadError;", "Lorg/readium/r2/shared/util/data/ReadTry;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "transform", "", "data", "(Lorg/readium/r2/shared/util/Try;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readium-streamer_release"})
    @SourceDebugExtension(value={"SMAP\nEpubDeobfuscator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EpubDeobfuscator.kt\norg/readium/r2/streamer/parser/epub/EpubDeobfuscator$DeobfuscatingResource\n+ 2 Try.kt\norg/readium/r2/shared/util/Try\n*L\n1#1,89:1\n51#2,4:90\n*S KotlinDebug\n*F\n+ 1 EpubDeobfuscator.kt\norg/readium/r2/streamer/parser/epub/EpubDeobfuscator$DeobfuscatingResource\n*L\n51#1:90,4\n*E\n"})
    public final class DeobfuscatingResource
    extends TransformingResource {
        @NotNull
        private final Resource resource;
        @NotNull
        private final String algorithm;

        public DeobfuscatingResource(@NotNull Resource resource, String algorithm) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            super(resource, false, 2, null);
            this.resource = resource;
            this.algorithm = algorithm;
        }

        @Nullable
        public Object length(@NotNull Continuation<? super Try<Long, ? extends ReadError>> $completion) {
            return this.resource.length($completion);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Object transform(@NotNull Try<byte[], ? extends ReadError> data, @NotNull Continuation<? super Try<byte[], ? extends ReadError>> $completion) {
            Try try_;
            void this_$iv;
            Try<byte[], ? extends ReadError> try_2 = data;
            EpubDeobfuscator epubDeobfuscator = EpubDeobfuscator.this;
            boolean $i$f$map = false;
            void var6_6 = this_$iv;
            if (var6_6 instanceof Try.Success) {
                void v1;
                void bytes;
                byte[] byArray = (byte[])((Try.Success)this_$iv).getValue();
                Try.Companion companion = Try.Companion;
                boolean bl = false;
                Integer n = (Integer)epubDeobfuscator.algorithm2length.get(this.algorithm);
                if (n == null) {
                    v1 = bytes;
                } else {
                    int obfuscationLength = n;
                    byte[] obfuscationKey = StringExtKt.toHexByteArray(Intrinsics.areEqual((Object)this.algorithm, (Object)"http://ns.adobe.com/pdf/enc#RC") ? epubDeobfuscator.getHashKeyAdobe(epubDeobfuscator.pubId) : StringExtKt.sha1(epubDeobfuscator.pubId));
                    if (obfuscationKey == null || obfuscationKey.length == 0) {
                        return Try.Companion.failure((Object)new ReadError.Decoding("The obfuscation key is not valid."));
                    }
                    epubDeobfuscator.deobfuscate((byte[])bytes, obfuscationKey, obfuscationLength);
                    v1 = bytes;
                }
                try_ = companion.success((Object)v1);
            } else if (var6_6 instanceof Try.Failure) {
                try_ = Try.Companion.failure(((Try.Failure)this_$iv).getValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return try_;
        }
    }
}

