/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.vavr.Tuple2;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.reactivecouchbase.json.JsArray;
import org.reactivecouchbase.json.JsBoolean;
import org.reactivecouchbase.json.JsNull;
import org.reactivecouchbase.json.JsNumber;
import org.reactivecouchbase.json.JsObject;
import org.reactivecouchbase.json.JsString;
import org.reactivecouchbase.json.JsUndefined;
import org.reactivecouchbase.json.JsValue;
import org.reactivecouchbase.json.Syntax;
import org.reactivecouchbase.json.Throwables;

public class Jackson {
    private static final ObjectMapper _defaultObjectMapper = Jackson.newDefaultMapper(Jackson.class.getClassLoader());
    private static final JsonFactory _defaultJsonFactory = new JsonFactory((ObjectCodec)_defaultObjectMapper);
    private static volatile ObjectMapper _objectMapper = null;
    private static volatile JsonFactory _jsonFactory = null;

    public static ObjectMapper newDefaultMapper(final ClassLoader classLoader) {
        SimpleModule jsonLibModule = new SimpleModule("json-lib", Version.unknownVersion()){

            public void setupModule(Module.SetupContext setupContext) {
                setupContext.addDeserializers((Deserializers)new JsDeserializers(classLoader));
                setupContext.addSerializers((Serializers)new JsSerializers());
            }
        };
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)jsonLibModule);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static ObjectMapper mapper() {
        if (_objectMapper == null) {
            return _defaultObjectMapper;
        }
        return _objectMapper;
    }

    public static JsonFactory factory() {
        if (_jsonFactory == null) {
            return _defaultJsonFactory;
        }
        return _jsonFactory;
    }

    public static void setObjectMapper(ObjectMapper mapper) {
        _objectMapper = mapper;
        _jsonFactory = new JsonFactory((ObjectCodec)_objectMapper);
    }

    public static JsonGenerator stringJsonGenerator(StringWriter out) {
        try {
            return Jackson.factory().createGenerator((Writer)out);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static JsonParser jsonParser(String str) {
        try {
            return Jackson.factory().createParser(str);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static JsValue parseJsValue(String in) {
        try {
            return (JsValue)Jackson.mapper().readValue(in, JsValue.class);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static String generateFromJsValue(JsValue in) {
        try {
            StringWriter sw = new StringWriter();
            JsonGenerator gen = Jackson.stringJsonGenerator(sw);
            Jackson.mapper().writeValue(gen, (Object)in);
            sw.flush();
            return sw.getBuffer().toString();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static String prettify(JsValue in) {
        try {
            StringWriter sw = new StringWriter();
            JsonGenerator gen = Jackson.stringJsonGenerator(sw).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            Jackson.mapper().writerWithDefaultPrettyPrinter().writeValue(gen, (Object)in);
            sw.flush();
            return sw.getBuffer().toString();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static JsonNode toJson(Object data) {
        try {
            return Jackson.mapper().valueToTree(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsValue jsonNodeToJsValue(JsonNode node) {
        try {
            return (JsValue)Jackson.mapper().treeToValue((TreeNode)node, JsValue.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode jsValueToJsonNode(JsValue val) {
        try {
            return Jackson.mapper().valueToTree((Object)val);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <A> A fromJson(JsonNode json, Class<A> clazz) {
        try {
            return (A)Jackson.mapper().treeToValue((TreeNode)json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class JsValueDeserializer
    extends JsonDeserializer<JsValue> {
        private final Class<?> clazz;
        private final TypeFactory factory;

        private JsValueDeserializer(TypeFactory factory, Class<?> clazz) {
            this.clazz = clazz;
            this.factory = factory;
        }

        public boolean isCachable() {
            return false;
        }

        public JsValue getNullValue() {
            return JsNull.JSNULL_INSTANCE;
        }

        public JsValue deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
            if (jp.getCurrentToken() == null) {
                jp.nextToken();
            }
            JsonToken token = jp.getCurrentToken();
            JsValue value = Syntax.nill();
            if (token.equals((Object)JsonToken.VALUE_NUMBER_FLOAT) || token.equals((Object)JsonToken.VALUE_NUMBER_INT)) {
                value = new JsNumber(jp.getDecimalValue());
            }
            if (token.equals((Object)JsonToken.VALUE_STRING)) {
                value = new JsString(jp.getText());
            }
            if (token.equals((Object)JsonToken.VALUE_TRUE)) {
                value = new JsBoolean(true);
            }
            if (token.equals((Object)JsonToken.VALUE_FALSE)) {
                value = new JsBoolean(false);
            }
            if (token.equals((Object)JsonToken.VALUE_NULL)) {
                value = JsNull.JSNULL_INSTANCE;
            }
            if (token.equals((Object)JsonToken.VALUE_EMBEDDED_OBJECT)) {
                jp.nextToken();
                value = this.readObject(jp, ctx);
            }
            if (token.equals((Object)JsonToken.START_OBJECT)) {
                jp.nextToken();
                value = this.readObject(jp, ctx);
            }
            if (token.equals((Object)JsonToken.START_ARRAY)) {
                jp.nextToken();
                value = this.readArray(jp, ctx);
            }
            jp.nextToken();
            if (!this.clazz.isAssignableFrom(value.getClass())) {
                throw ctx.mappingException(this.clazz);
            }
            return value;
        }

        private JsObject readObject(JsonParser jp, DeserializationContext ctx) throws IOException, JsonParseException {
            JsObject object = new JsObject();
            while (jp.getCurrentToken() != null && !jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT)) {
                JsonToken token = jp.getCurrentToken();
                if (token.equals((Object)JsonToken.FIELD_NAME)) {
                    String key = jp.getCurrentName();
                    jp.nextToken();
                    JsValue val = this.deserialize(jp, ctx);
                    object = object.add(Syntax.$(key, val));
                }
                if (token.equals((Object)JsonToken.FIELD_NAME)) continue;
                jp.nextToken();
            }
            return object;
        }

        private JsArray readArray(JsonParser jp, DeserializationContext ctx) throws IOException, JsonParseException {
            JsArray array = new JsArray();
            while (jp.getCurrentToken() != null && !jp.getCurrentToken().equals((Object)JsonToken.END_ARRAY)) {
                JsValue val = this.deserialize(jp, ctx);
                array = array.addElement(val);
            }
            return array;
        }
    }

    private static class JsValueSerializer
    extends JsonSerializer<JsValue> {
        private static final BigDecimal MaxPlain = new BigDecimal(1.0E20);
        private static final BigDecimal MinPlain = new BigDecimal(1.0E-10);

        private JsValueSerializer() {
        }

        public void serialize(JsValue value, JsonGenerator json, SerializerProvider provider) throws IOException, JsonProcessingException {
            for (JsNumber number : value.asOpt(JsNumber.class)) {
                BigDecimal v = number.value;
                BigDecimal va = v.abs();
                boolean shouldWritePlain = va.compareTo(MaxPlain) < 0 && va.compareTo(MinPlain) > 0;
                BigDecimal stripped = v.stripTrailingZeros();
                String raw = stripped.toString();
                if (shouldWritePlain) {
                    raw = stripped.toPlainString();
                }
                if (raw.indexOf(69) < 0 && raw.indexOf(46) < 0) {
                    json.writeTree((TreeNode)new BigIntegerNode(new BigInteger(raw)));
                    continue;
                }
                json.writeTree((TreeNode)new DecimalNode(new BigDecimal(raw)));
            }
            for (JsString str : value.asOpt(JsString.class)) {
                json.writeString(str.value);
            }
            for (JsBoolean bool : value.asOpt(JsBoolean.class)) {
                json.writeBoolean(bool.value.booleanValue());
            }
            for (JsValue nevermind : value.asOpt(JsNull.class)) {
                json.writeNull();
            }
            for (JsValue nevermind : value.asOpt(JsUndefined.class)) {
                json.writeNull();
            }
            for (JsArray array : value.asOpt(JsArray.class)) {
                json.writeStartArray();
                for (JsValue val : array.values) {
                    this.serialize(val, json, provider);
                }
                json.writeEndArray();
            }
            for (JsObject obj : value.asOpt(JsObject.class)) {
                json.writeStartObject();
                for (JsValue val : obj.values.toList()) {
                    json.writeFieldName((String)((Tuple2)val)._1);
                    this.serialize((JsValue)((Tuple2)val)._2, json, provider);
                }
                json.writeEndObject();
            }
        }
    }

    public static class JsSerializers
    extends Serializers.Base {
        public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
            if (JsValue.class.isAssignableFrom(beanDescription.getBeanClass())) {
                return new JsValueSerializer();
            }
            return null;
        }
    }

    public static class JsDeserializers
    extends Deserializers.Base {
        private final ClassLoader classLoader;

        public JsDeserializers(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
            Class clazz = javaType.getRawClass();
            if (JsValue.class.isAssignableFrom(clazz) || clazz.equals(JsNull.class)) {
                return new JsValueDeserializer(deserializationConfig.getTypeFactory(), clazz);
            }
            return null;
        }
    }
}

