/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json.mapping;

import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.function.Function;
import org.reactivecouchbase.json.mapping.JsError;
import org.reactivecouchbase.json.mapping.JsSuccess;

public abstract class JsResult<T>
implements Iterable<T> {
    public abstract T get();

    public abstract Option<T> getOpt();

    public Option<T> asOpt() {
        return this.getOpt();
    }

    public abstract JsResult<T> getOrElse(JsResult<T> var1);

    public abstract T getValueOrNull();

    public abstract T getValueOrElse(T var1);

    public abstract T getValueOrElse(Throwable var1);

    public abstract <B> JsResult<B> map(Function<T, B> var1);

    public abstract <B> JsResult<B> flatMap(Function<T, JsResult<B>> var1);

    public abstract JsResult<T> filter(Function<T, Boolean> var1);

    public abstract JsResult<T> filterNot(Function<T, Boolean> var1);

    public abstract JsResult<T> filter(Function<T, Boolean> var1, Seq<Throwable> var2);

    public abstract JsResult<T> filterNot(Function<T, Boolean> var1, Seq<Throwable> var2);

    public abstract JsResult<T> filter(Function<T, Boolean> var1, Throwable var2);

    public abstract JsResult<T> filterNot(Function<T, Boolean> var1, Throwable var2);

    public abstract boolean hasErrors();

    public abstract boolean isErrors();

    public abstract boolean isSuccess();

    public abstract int countErrors();

    public abstract Option<JsError<T>> asError();

    public abstract Option<JsSuccess<T>> asSuccess();

    public JsError<T> toError() {
        return (JsError)this.asError().get();
    }

    public JsSuccess<T> toSuccess() {
        return (JsSuccess)this.asSuccess().get();
    }

    public static <T> JsResult<T> error(Throwable t) {
        return new JsError(t);
    }

    public static <T> JsResult<T> success(T t) {
        return new JsSuccess<T>(t);
    }

    public <X> X fold(Function<JsError<T>, X> onError, Function<JsSuccess<T>, X> onSuccess) {
        if (this.isErrors()) {
            return onError.apply(this.toError());
        }
        return onSuccess.apply(this.toSuccess());
    }

    public <X> X transform(Function<JsResult<T>, X> trans) {
        return trans.apply(this);
    }

    public Option<Throwable> onError() {
        if (this.isErrors()) {
            return Option.some((Object)((JsError)this.asError().get()).firstError());
        }
        return Option.none();
    }

    public Seq<Throwable> onErrors() {
        if (this.isErrors()) {
            return ((JsError)this.asError().get()).errors;
        }
        return Array.empty();
    }

    public Option<T> onSuccess() {
        if (this.isSuccess()) {
            return Option.some(this.get());
        }
        return Option.none();
    }

    public abstract T orError(Throwable var1);

    public T recover(Function<JsError, T> block) {
        if (this.isSuccess()) {
            return this.get();
        }
        return block.apply((JsError)this.asError().get());
    }

    private static <T> JsResult<T> populateErrs(JsResult<T> finalResult, JsResult<?> ... results) {
        Array throwables = Array.empty();
        for (JsResult<?> res : results) {
            if (!res.isErrors()) continue;
            throwables = throwables.appendAll(((JsError)res.asError().get()).errors);
        }
        if (throwables.isEmpty() && finalResult.isSuccess()) {
            return new JsSuccess(((JsSuccess)finalResult.asSuccess().get()).get());
        }
        return new JsError((Seq<Throwable>)throwables);
    }
}

