/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json;

import io.vavr.CheckedFunction0;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Function;
import org.reactivecouchbase.json.JsBoolean;
import org.reactivecouchbase.json.JsNull;
import org.reactivecouchbase.json.JsNumber;
import org.reactivecouchbase.json.JsPair;
import org.reactivecouchbase.json.JsString;
import org.reactivecouchbase.json.JsUndefined;
import org.reactivecouchbase.json.JsValue;
import org.reactivecouchbase.json.Syntax;
import org.reactivecouchbase.json.Throwables;
import org.reactivecouchbase.json.mapping.JsError;
import org.reactivecouchbase.json.mapping.JsResult;
import org.reactivecouchbase.json.mapping.Reader;

public class JsObject
extends JsValue
implements Iterable<Tuple2<String, JsValue>> {
    public final Map<String, JsValue> values;

    public static JsObject apply(Map<String, JsValue> values) {
        return new JsObject(values);
    }

    public static JsObject apply() {
        return new JsObject();
    }

    public JsObject(Map<String, JsValue> values) {
        if (values == null) {
            throw new IllegalArgumentException("Values can't be null !");
        }
        this.values = values;
    }

    public JsObject() {
        this.values = HashMap.empty();
    }

    public JsObject merge(JsObject with) {
        if (with == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        return new JsObject((Map<String, JsValue>)with.values.merge(this.values));
    }

    @Override
    public Iterator<Tuple2<String, JsValue>> iterator() {
        return this.values.toList().iterator();
    }

    public JsObject deepMerge(JsObject with) {
        if (with == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        Map newValues = with.values;
        for (Tuple2 entry : this.values.toList()) {
            if (with.values.containsKey(entry._1()) && ((JsValue)entry._2()).is(JsObject.class)) {
                newValues = newValues.put(entry._1(), (Object)((JsValue)entry._2()).as(JsObject.class).deepMerge(((JsValue)with.values.get(entry._1()).get()).as(JsObject.class)));
                continue;
            }
            newValues = newValues.put(entry._1(), entry._2());
        }
        return new JsObject(newValues);
    }

    public Set<String> fieldsSet() {
        return this.values.keySet();
    }

    public Seq<JsValue> values() {
        return this.values.values();
    }

    public JsObject add(JsObject jsObject) {
        if (jsObject == null) {
            return new JsObject(this.values);
        }
        return new JsObject((Map<String, JsValue>)jsObject.values.merge(this.values));
    }

    public JsObject add(String key, Option<JsValue> optVal) {
        if (optVal.isDefined()) {
            return this.add(Syntax.$(key, (JsValue)optVal.get()));
        }
        return new JsObject(this.values);
    }

    public JsObject addOrNull(String key, Option<JsValue> optVal) {
        if (optVal.isDefined()) {
            return this.add(Syntax.$(key, (JsValue)optVal.get()));
        }
        return this.add(Syntax.$(key, Syntax.nill()));
    }

    public JsObject update(String key, Function<JsValue, JsValue> value) {
        Option<JsValue> field = this.fieldAsOpt(key);
        io.vavr.collection.Iterator iterator = field.iterator();
        if (iterator.hasNext()) {
            JsValue val = (JsValue)iterator.next();
            return this.add(key, (Option<JsValue>)Option.of((Object)value.apply(val)));
        }
        return this;
    }

    public JsObject updateOpt(String key, Function<JsValue, Option<JsValue>> value) {
        Option<JsValue> field = this.fieldAsOpt(key);
        io.vavr.collection.Iterator iterator = field.iterator();
        if (iterator.hasNext()) {
            JsValue val = (JsValue)iterator.next();
            return this.add(key, value.apply(val));
        }
        return this;
    }

    public JsObject upsert(String key, Function<Option<JsValue>, JsValue> value) {
        Option<JsValue> field = this.fieldAsOpt(key);
        JsValue ret = value.apply(field);
        return this.add(key, (Option<JsValue>)Option.of((Object)ret));
    }

    public JsObject upsertOpt(String key, Function<Option<JsValue>, Option<JsValue>> value) {
        Option<JsValue> field = this.fieldAsOpt(key);
        Option<JsValue> ret = value.apply(field);
        if (ret == null) {
            return this;
        }
        return this.add(key, ret);
    }

    public JsObject remove(String field) {
        if (field == null) {
            return new JsObject(this.values);
        }
        return new JsObject((Map<String, JsValue>)this.values.remove((Object)field));
    }

    @Override
    public JsValue field(String field) {
        if (field == null) {
            return JsUndefined.JSUNDEFINED_INSTANCE;
        }
        return (JsValue)this.values.get((Object)field).getOrElse((Object)JsUndefined.JSUNDEFINED_INSTANCE);
    }

    @Override
    public Option<JsValue> fieldAsOpt(String field) {
        if (field == null) {
            return Option.none();
        }
        return this.values.get((Object)field);
    }

    @Override
    public Seq<JsValue> fields(String fieldName) {
        if (fieldName == null) {
            return Array.empty();
        }
        return this.values.toList().flatMap(tuple -> {
            String key = (String)tuple._1;
            JsValue value = (JsValue)tuple._2;
            if (key.equals(fieldName)) {
                return Array.of((Object)value);
            }
            io.vavr.collection.Iterator iterator = value.asOpt(JsObject.class).iterator();
            if (iterator.hasNext()) {
                JsObject obj = (JsObject)iterator.next();
                return obj.fields(fieldName);
            }
            iterator = value.asOpt(JsPair.class).iterator();
            if (iterator.hasNext()) {
                JsObject obj = (JsObject)iterator.next();
                return obj.fields(fieldName);
            }
            return Array.empty();
        });
    }

    @Override
    String toJsonString() {
        return "{" + this.toJsonPairString() + "}";
    }

    public String toString() {
        return "JsObject(" + this.toJsonPairString() + ")";
    }

    private String toJsonPairString() {
        return this.values.toList().map(tuple -> "\"" + (String)tuple._1 + "\":" + ((JsValue)tuple._2).toJsonString()).mkString((CharSequence)",");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsObject)) {
            return false;
        }
        JsObject object = (JsObject)o;
        return this.values.equals(object.values);
    }

    @Override
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsObject)) {
            return false;
        }
        JsObject object = (JsObject)o;
        for (Tuple2 value : this.values.toList()) {
            JsValue field = object.field((String)value._1());
            if (field.deepEquals(value._2())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public Boolean exists(String field) {
        return this.values.containsKey((Object)field);
    }

    public JsObject mapProperties(Function<Tuple2<String, JsValue>, JsValue> block) {
        return new JsObject((Map<String, JsValue>)this.values.map(t -> Tuple.of((Object)t._1, block.apply((Tuple2<String, JsValue>)t))).toMap(t -> t));
    }

    public <T> Map<String, T> mapPropertiesWith(Reader<T> reader) {
        return this.values.map(t -> {
            JsResult result = reader.read((JsValue)t._2);
            if (result.isErrors()) {
                throw Throwables.propagate(((JsError)result.asError().get()).firstError());
            }
            return Tuple.of((Object)t._1, result.get());
        }).toMap(t -> t);
    }

    public <T> Map<String, T> mapPropertiesWith(Reader<T> reader, Function<JsResult<T>, T> onError) {
        return this.values.map(t -> {
            JsResult result = reader.read((JsValue)t._2);
            if (result.isErrors()) {
                return Tuple.of((Object)t._1, onError.apply(result));
            }
            return Tuple.of((Object)t._1, result.get());
        }).toMap(t -> t);
    }

    public int nbrOfElements() {
        return this.size();
    }

    public int size() {
        return this.values == null ? 0 : this.values.size();
    }

    public boolean isEmpty() {
        return this.values == null || this.values.isEmpty();
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public JsObject cloneNode() {
        return new JsObject((Map<String, JsValue>)HashMap.ofEntries(this.values));
    }

    public JsObject with(String key) {
        return this.add(new JsPair(key, JsNull.JSNULL_INSTANCE));
    }

    public JsObject withNull(String key) {
        return this.add(new JsPair(key, JsNull.JSNULL_INSTANCE));
    }

    public JsObject withUndefined(String key) {
        return this.add(new JsPair(key, JsUndefined.JSUNDEFINED_INSTANCE));
    }

    public <T extends JsValue> JsObject with(String key, T value) {
        return this.add(new JsPair(key, value));
    }

    public <T extends JsValue> JsObject with(String key, Option<T> value) {
        return this.add(key, (Option<JsValue>)value.flatMap(v -> Try.of((CheckedFunction0 & Serializable)() -> (JsValue)JsValue.class.cast(v)).toOption()));
    }

    public JsObject with(String key, Integer value) {
        return this.add(new JsPair(key, value));
    }

    public JsObject with(String key, Long value) {
        return this.add(new JsPair(key, value));
    }

    public JsObject with(String key, Double value) {
        return this.add(new JsPair(key, value));
    }

    public JsObject with(String key, BigInteger value) {
        return this.add(new JsPair(key, value));
    }

    public JsObject with(String key, BigDecimal value) {
        return this.add(new JsPair(key, value));
    }

    public JsObject with(String key, Boolean value) {
        return this.add(new JsPair(key, value));
    }

    public JsObject with(String key, String value) {
        return this.add(new JsPair(key, value));
    }

    public JsObject withInt(String key, Option<Integer> value) {
        return this.add(key, (Option<JsValue>)value.map(JsNumber::new));
    }

    public JsObject withLong(String key, Option<Long> value) {
        return this.add(key, (Option<JsValue>)value.map(JsNumber::new));
    }

    public JsObject withDouble(String key, Option<Double> value) {
        return this.add(key, (Option<JsValue>)value.map(JsNumber::new));
    }

    public JsObject withBigInt(String key, Option<BigInteger> value) {
        return this.add(key, (Option<JsValue>)value.map(JsNumber::new));
    }

    public JsObject withBigDec(String key, Option<BigDecimal> value) {
        return this.add(key, (Option<JsValue>)value.map(JsNumber::new));
    }

    public JsObject withBoolean(String key, Option<Boolean> value) {
        return this.add(key, (Option<JsValue>)value.map(JsBoolean::new));
    }

    public JsObject withString(String key, Option<String> value) {
        return this.add(key, (Option<JsValue>)value.map(JsString::new));
    }
}

