/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json;

import io.vavr.control.Option;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.reactivecouchbase.json.JsUndefined;
import org.reactivecouchbase.json.JsValue;

public class JsNumber
extends JsValue
implements Comparable<JsNumber> {
    public final BigDecimal value;

    public static JsNumber apply(BigDecimal value) {
        return new JsNumber(value);
    }

    public static JsNumber apply(BigInteger value) {
        return new JsNumber(value);
    }

    public static JsNumber apply(Integer value) {
        return new JsNumber(value);
    }

    public static JsNumber apply(Long value) {
        return new JsNumber(value);
    }

    public static JsNumber apply(Double value) {
        return new JsNumber(value);
    }

    public static JsNumber apply(Float value) {
        return new JsNumber(value);
    }

    public static JsNumber apply(Short value) {
        return new JsNumber(value);
    }

    public JsNumber(BigDecimal value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        this.value = value;
    }

    public JsNumber(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        this.value = new BigDecimal(value);
    }

    public JsNumber(Integer value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        this.value = BigDecimal.valueOf(value.intValue()).setScale(0);
    }

    public JsNumber(Long value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        this.value = BigDecimal.valueOf(value).setScale(0);
    }

    public JsNumber(Double value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        this.value = BigDecimal.valueOf(value);
    }

    public JsNumber(Float value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        this.value = BigDecimal.valueOf(value.floatValue());
    }

    public JsNumber(Short value) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null !");
        }
        this.value = BigDecimal.valueOf(value.shortValue()).setScale(0);
    }

    @Override
    public JsValue querySelector(String query) {
        return JsUndefined.JSUNDEFINED_INSTANCE;
    }

    @Override
    public Option<JsValue> querySelectorOpt(String query) {
        return Option.none();
    }

    @Override
    public int compareTo(JsNumber jsNumber) {
        return this.value.compareTo(jsNumber.value);
    }

    @Override
    String toJsonString() {
        return this.value.toPlainString();
    }

    public String toString() {
        return "JsNumber(" + this.value.toPlainString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsNumber)) {
            return false;
        }
        JsNumber jsNumber = (JsNumber)o;
        return this.value.equals(jsNumber.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean deepEquals(Object o) {
        return this.equals(o);
    }

    @Override
    public JsNumber cloneNode() {
        return new JsNumber(this.value);
    }
}

