/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecouchbase.json;

import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivecouchbase.json.JsUndefined;
import org.reactivecouchbase.json.JsValue;
import org.reactivecouchbase.json.Throwables;
import org.reactivecouchbase.json.mapping.JsError;
import org.reactivecouchbase.json.mapping.JsResult;
import org.reactivecouchbase.json.mapping.Reader;

public class JsArray
extends JsValue
implements Iterable<JsValue> {
    public final Seq<JsValue> values;

    public static JsArray apply(Seq<JsValue> values) {
        return new JsArray(values);
    }

    public static JsArray apply() {
        return new JsArray();
    }

    public JsArray(Seq<JsValue> values) {
        if (values == null) {
            throw new IllegalArgumentException("Values can't be null !");
        }
        this.values = values;
    }

    public JsArray() {
        this.values = Array.empty();
    }

    public boolean contains(JsValue value) {
        return this.values.contains((Object)value);
    }

    @Override
    public Iterator<JsValue> iterator() {
        return this.values.iterator();
    }

    @Override
    public JsValue get(int idx) {
        try {
            return (JsValue)this.values.get(idx);
        }
        catch (Exception e) {
            return JsUndefined.JSUNDEFINED_INSTANCE;
        }
    }

    public JsArray append(JsArray arr) {
        if (arr == null) {
            return new JsArray(this.values);
        }
        return new JsArray((Seq<JsValue>)this.values.appendAll(arr.values));
    }

    public JsArray preprend(JsArray arr) {
        if (arr == null) {
            return new JsArray(this.values);
        }
        return new JsArray((Seq<JsValue>)this.values.prependAll(arr.values));
    }

    public JsArray addElement(JsValue arr) {
        if (arr == null) {
            return new JsArray(this.values);
        }
        return new JsArray((Seq<JsValue>)this.values.append((Object)arr));
    }

    public JsArray preprendElement(JsValue arr) {
        if (arr == null) {
            return new JsArray(this.values);
        }
        return new JsArray((Seq<JsValue>)this.values.prepend((Object)arr));
    }

    public JsArray map(Function<JsValue, JsValue> map) {
        return new JsArray((Seq<JsValue>)this.values.map(map));
    }

    public <T> Seq<T> mapWith(Reader<T> reader) {
        return this.values.map(i -> {
            JsResult result = i.read(reader);
            if (result.hasErrors()) {
                throw Throwables.propagate(((JsError)result.asError().get()).firstError());
            }
            return result.get();
        });
    }

    public <T> Seq<T> mapWith(Reader<T> reader, Function<JsResult<T>, T> onError) {
        return this.values.map(i -> {
            JsResult result = i.read(reader);
            if (result.hasErrors()) {
                return onError.apply(result);
            }
            return result.get();
        });
    }

    public JsArray filter(Predicate<JsValue> predicate) {
        return new JsArray((Seq<JsValue>)this.values.filter(predicate));
    }

    public JsArray filterNot(Predicate<JsValue> predicate) {
        return new JsArray((Seq<JsValue>)this.values.filter(predicate.negate()));
    }

    @Override
    String toJsonString() {
        return "[" + this.values.map(JsValue::toJsonString).mkString((CharSequence)",") + "]";
    }

    public String toString() {
        return "JsArray[" + this.values.map(JsValue::toJsonString).mkString((CharSequence)", ") + "]";
    }

    public int size() {
        return this.values == null ? 0 : this.values.size();
    }

    public boolean isEmpty() {
        return this.values == null || this.values.isEmpty();
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsArray)) {
            return false;
        }
        JsArray jsArray = (JsArray)o;
        return this.values.equals(jsArray.values);
    }

    @Override
    public boolean deepEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsArray)) {
            return false;
        }
        JsArray jsArray = (JsArray)o;
        for (int i = 0; i < this.size(); ++i) {
            JsValue v1 = this.get(i);
            JsValue v2 = jsArray.get(i);
            if (v1 == null && v2 == null) continue;
            if (v1 != null && v2 == null) {
                return false;
            }
            if (v1 == null && v2 != null) {
                return false;
            }
            if (v1.deepEquals(v2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public JsArray cloneNode() {
        return new JsArray((Seq<JsValue>)Array.ofAll(this.values));
    }
}

