/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.rdfhdt.hdt.options.HDTOptions;

public class Profiler
implements AutoCloseable {
    private static final AtomicLong PROFILER_IDS = new AtomicLong();
    private static final Map<Long, Profiler> PROFILER = new HashMap<Long, Profiler>();
    private static final byte[] HEADER = new byte[]{72, 68, 84, 80, 82, 79, 70, 73, 76, 69};
    private int maxSize = 0;
    private final String name;
    private Section mainSection;
    private boolean disabled;
    private Path outputPath;
    private final long id = PROFILER_IDS.incrementAndGet();
    private int deep = 0;

    public static Profiler getProfilerById(long id) {
        return PROFILER.get(id);
    }

    public static Profiler readFromDisk(Path inputPath) throws IOException {
        Profiler p = new Profiler("");
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(inputPath, new OpenOption[0]));){
            for (byte b : HEADER) {
                if (((InputStream)is).read() == b) continue;
                throw new IOException("Missing header for the profiling file!");
            }
            Profiler profiler = p;
            Objects.requireNonNull(profiler);
            p.mainSection = profiler.new Section(is, 0);
            int checkSum = p.mainSection.computeCheckSum();
            int checkSumRead = (int)Profiler.readLong(is);
            if (checkSumRead != checkSum) {
                throw new IOException("the Checksum isn't the same");
            }
        }
        return p;
    }

    private static long readLong(InputStream is) throws IOException {
        byte[] longBuffer = Profiler.readBuffer(is, 8);
        return (long)(longBuffer[0] & 0xFF) | ((long)longBuffer[1] & 0xFFL) << 8 | ((long)longBuffer[2] & 0xFFL) << 16 | ((long)longBuffer[3] & 0xFFL) << 24 | ((long)longBuffer[4] & 0xFFL) << 32 | ((long)longBuffer[5] & 0xFFL) << 40 | ((long)longBuffer[6] & 0xFFL) << 48 | ((long)longBuffer[7] & 0xFFL) << 56;
    }

    private static void writeLong(OutputStream os, long value) throws IOException {
        os.write((byte)(value & 0xFFL));
        os.write((byte)(value >>> 8 & 0xFFL));
        os.write((byte)(value >>> 16 & 0xFFL));
        os.write((byte)(value >>> 24 & 0xFFL));
        os.write((byte)(value >>> 32 & 0xFFL));
        os.write((byte)(value >>> 40 & 0xFFL));
        os.write((byte)(value >>> 48 & 0xFFL));
        os.write((byte)(value >>> 56 & 0xFFL));
    }

    private static byte[] readBuffer(InputStream input, int length) throws IOException {
        int nRead;
        int pos = 0;
        byte[] data = new byte[length];
        while ((nRead = input.read(data, pos, length - pos)) > 0) {
            pos += nRead;
        }
        if (pos != length) {
            throw new EOFException("EOF while reading array from InputStream");
        }
        return data;
    }

    public static Profiler createOrLoadSubSection(String name, HDTOptions options, boolean setId) {
        return Profiler.createOrLoadSubSection(name, options, setId, false);
    }

    public static Profiler createOrLoadSubSection(String name, HDTOptions options, boolean setId, boolean async) {
        Profiler prof;
        if (options == null) {
            return new Profiler(name, null, async);
        }
        String profiler = options.get(async ? "profiler.async" : "profiler");
        if (profiler != null && profiler.length() != 0 && profiler.charAt(0) == '!' && (prof = Profiler.getProfilerById(Long.parseLong(profiler.substring(1)))) != null) {
            prof.pushSection(name);
            ++prof.deep;
            return prof;
        }
        prof = new Profiler(name, options, async);
        if (setId) {
            options.set(async ? "profiler.async" : "profiler", prof);
        }
        return prof;
    }

    public Profiler(String name) {
        this(name, false);
    }

    public Profiler(String name, boolean async) {
        this(name, null, async);
    }

    public Profiler(String name, HDTOptions spec) {
        this(name, spec, false);
    }

    public Profiler(String name, HDTOptions spec, boolean async) {
        PROFILER.put(this.id, this);
        this.name = Objects.requireNonNull(name, "name can't be null!");
        if (spec != null) {
            String b = spec.get(async ? "profiler.async" : "profiler");
            this.disabled = b == null || b.length() == 0 || b.charAt(0) != '!' && !"true".equalsIgnoreCase(b);
            String profilerOutputLocation = spec.get(async ? "profiler.async.output" : "profiler.output");
            if (profilerOutputLocation != null && !profilerOutputLocation.isEmpty()) {
                this.outputPath = Path.of(profilerOutputLocation, new String[0]);
            }
        } else {
            this.disabled = true;
        }
    }

    public void setDisabled(boolean disable) {
        this.disabled = disable;
    }

    public void pushSection(String name) {
        if (this.disabled) {
            return;
        }
        this.getMainSection().pushSection(name, 0);
    }

    public long getId() {
        return this.id;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void popSection() {
        if (this.disabled) {
            return;
        }
        if (!this.getMainSection().isRunning()) {
            throw new IllegalArgumentException("profiler not running!");
        }
        this.getMainSection().popSection();
    }

    public void stop() {
        if (this.disabled || this.deep != 0) {
            return;
        }
        this.getMainSection().stop();
    }

    public void reset() {
        this.mainSection = null;
    }

    public void writeProfiling() throws IOException {
        if (this.disabled || this.deep != 0) {
            return;
        }
        this.getMainSection().writeProfiling("", true);
        if (this.outputPath != null) {
            this.writeToDisk(this.outputPath);
        }
    }

    public void writeToDisk(Path outputPath) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));){
            for (byte b : HEADER) {
                ((OutputStream)os).write(b);
            }
            Section mainSection = this.getMainSection();
            mainSection.writeSection(os);
            Profiler.writeLong(os, mainSection.computeCheckSum());
        }
    }

    public Section getMainSection() {
        if (this.mainSection == null) {
            this.mainSection = new Section(this.name);
            this.maxSize = Math.max(this.name.length() + this.deep * 2, this.maxSize);
        }
        return this.mainSection;
    }

    @Override
    public void close() {
        if (this.deep == 0) {
            PROFILER.remove(this.getId());
        } else {
            --this.deep;
            this.popSection();
        }
    }

    public class Section {
        private final String name;
        private final long start;
        private long end;
        private final List<Section> subSections;
        private transient Section currentSection;

        Section(String name) {
            this.name = name;
            this.end = this.start = System.currentTimeMillis();
            this.subSections = new ArrayList<Section>();
        }

        Section(InputStream is, int deep) throws IOException {
            this.start = Profiler.readLong(is);
            this.end = Profiler.readLong(is);
            int nameLength = (int)Profiler.readLong(is);
            byte[] nameBytes = Profiler.readBuffer(is, nameLength);
            this.name = new String(nameBytes, StandardCharsets.UTF_8);
            Profiler.this.maxSize = Math.max(this.name.length() + deep * 2, Profiler.this.maxSize);
            int subSize = (int)Profiler.readLong(is);
            this.subSections = new ArrayList<Section>(subSize);
            for (int i = 0; i < subSize; ++i) {
                this.subSections.add(new Section(is, deep + 1));
            }
        }

        void writeSection(OutputStream os) throws IOException {
            byte[] nameBytes = this.name.getBytes(StandardCharsets.UTF_8);
            Profiler.writeLong(os, this.start);
            Profiler.writeLong(os, this.end);
            Profiler.writeLong(os, nameBytes.length);
            os.write(nameBytes);
            List<Section> sub = this.getSubSections();
            Profiler.writeLong(os, sub.size());
            for (Section s : sub) {
                s.writeSection(os);
            }
        }

        public List<Section> getSubSections() {
            return this.subSections;
        }

        public String getName() {
            return this.name;
        }

        boolean isRunning() {
            return this.currentSection != null;
        }

        void pushSection(String name, int deep) {
            if (this.isRunning()) {
                this.currentSection.pushSection(name, deep + 1);
                return;
            }
            this.currentSection = new Section(name);
            this.subSections.add(this.currentSection);
            Profiler.this.maxSize = Math.max(name.length() + deep * 2, Profiler.this.maxSize);
        }

        boolean popSection() {
            if (this.isRunning()) {
                if (this.currentSection.popSection()) {
                    this.currentSection = null;
                }
                return false;
            }
            this.end = System.currentTimeMillis();
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Section section = (Section)o;
            return this.start == section.start && this.end == section.end && this.name.equals(section.name) && this.subSections.equals(section.subSections);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            result = 31 * result + (int)(this.end ^ this.end >>> 32);
            result = 31 * result + this.subSections.hashCode();
            return result;
        }

        public String toString() {
            return "Section{name='" + this.name + "', start=" + this.start + ", end=" + this.end + ", subSections=" + this.subSections + ", currentSection=" + this.currentSection + "}";
        }

        void stop() {
            if (this.isRunning()) {
                this.currentSection.stop();
            }
            this.end = System.currentTimeMillis();
        }

        public long getMillis() {
            return this.end - this.start;
        }

        public long getStartMillis() {
            return this.start;
        }

        public long getEndMillis() {
            return this.end;
        }

        void writeProfiling(String prefix, boolean isLast) {
            System.out.println(prefix + (this.getSubSections().isEmpty() ? "+--" : "+-+") + " [" + this.getName() + "] " + "-".repeat(1 + Profiler.this.maxSize - this.getName().length()) + " elapsed=" + this.getMillis() + "ms");
            for (int i = 0; i < this.subSections.size(); ++i) {
                Section s = this.subSections.get(i);
                s.writeProfiling(prefix + (isLast ? "  " : "| "), i == this.subSections.size() - 1);
            }
        }

        public int computeCheckSum() {
            int result = this.name.length();
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            result = 31 * result + (int)(this.end ^ this.end >>> 32);
            for (Section subSection : this.subSections) {
                result = 31 * result ^ subSection.computeCheckSum();
            }
            return result;
        }
    }
}

