/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.LongFunction;
import org.rdfhdt.hdt.triples.TripleString;

public abstract class RDFFluxStop {
    private static final Map<String, LongFunction<RDFFluxStop>> BUILDER = new HashMap<String, LongFunction<RDFFluxStop>>();
    private static final Map<Character, BiFunction<RDFFluxStop, RDFFluxStop, RDFFluxStop>> BUILDER_OP = new HashMap<Character, BiFunction<RDFFluxStop, RDFFluxStop, RDFFluxStop>>();
    private static final RDFFluxStop EMPTY = new RDFFluxStop(){

        @Override
        public boolean canHandle(TripleString ts) {
            return false;
        }

        @Override
        public void restart() {
        }

        @Override
        public String asConfig() {
            return "";
        }
    };
    private static final RDFFluxStop NO_LIMIT = new RDFFluxStop(){

        @Override
        public boolean canHandle(TripleString ts) {
            return true;
        }

        @Override
        public void restart() {
        }

        @Override
        public String asConfig() {
            return "no_limit:0";
        }
    };

    public static void registerCustomRDFFluxStopConfig(String name, LongFunction<RDFFluxStop> builder) {
        name.chars().forEach(c -> {
            if (!Character.isJavaIdentifierPart(c)) {
                throw new IllegalArgumentException("Config can't contain non identifier part! Found '" + c + "'");
            }
        });
        BUILDER.put(name, builder);
    }

    public static void registerCustomRDFFluxStopOperator(char operator, BiFunction<RDFFluxStop, RDFFluxStop, RDFFluxStop> builder) {
        if (Character.isJavaIdentifierPart(operator) || operator == '(' || operator == ')') {
            throw new IllegalArgumentException("Operator can't be an identifier part or a parenthesis! Found '" + operator + "'");
        }
        BUILDER_OP.put(Character.valueOf(operator), builder);
    }

    private static int searchNextParenthesis(String cfg, int start) {
        int deep = 0;
        block4: for (int i = start; i < cfg.length(); ++i) {
            switch (cfg.charAt(i)) {
                case '(': {
                    ++deep;
                    continue block4;
                }
                case ')': {
                    if (deep == 0) {
                        return i;
                    }
                    --deep;
                }
            }
        }
        throw new IllegalArgumentException("Can't find next parenthesis for start " + start);
    }

    public static RDFFluxStop readConfig(String cfg, int start, int end) {
        if (cfg == null) {
            return null;
        }
        int i = start;
        RDFFluxStop element = null;
        while (i < end) {
            char c;
            if ((c = cfg.charAt(i++)) == '(') {
                if (element != null) {
                    throw new IllegalArgumentException("Find an element after another one without having an operator! " + (i - 1));
                }
                int next = RDFFluxStop.searchNextParenthesis(cfg, i);
                element = RDFFluxStop.readConfig(cfg, i, next);
                i = next + 1;
                continue;
            }
            if (c == ')') {
                throw new IllegalArgumentException("Find closing parenthesis without opening! " + (i - 1));
            }
            if (Character.isJavaIdentifierPart(c)) {
                int j;
                int startElement = i - 1;
                for (j = i; j < end && Character.isJavaIdentifierPart(cfg.charAt(j)); ++j) {
                }
                if (j == end || cfg.charAt(j) != ':') {
                    throw new IllegalArgumentException("Identifier without value: " + startElement);
                }
                String key = cfg.substring(startElement, j);
                LongFunction<RDFFluxStop> builder = BUILDER.get(key);
                if (builder == null) {
                    throw new IllegalArgumentException("Can't find option: " + key);
                }
                startElement = j + 1;
                if (startElement == end || !Character.isDigit(cfg.charAt(startElement))) {
                    throw new IllegalArgumentException("Identifier without number value: " + key + ", " + startElement);
                }
                for (j = startElement; j < end && Character.isDigit(cfg.charAt(j)); ++j) {
                }
                long value = Long.parseLong(cfg.substring(startElement, j));
                element = builder.apply(value);
                i = j;
                continue;
            }
            BiFunction<RDFFluxStop, RDFFluxStop, RDFFluxStop> opFunc = BUILDER_OP.get(Character.valueOf(c));
            if (opFunc == null) {
                throw new IllegalArgumentException("Unknow component: " + c + ", " + (i - 1));
            }
            if (element == null) {
                element = EMPTY;
            }
            return opFunc.apply(element, RDFFluxStop.readConfig(cfg, i, end));
        }
        return element;
    }

    public static RDFFluxStop readConfig(String cfg) {
        return cfg == null ? null : RDFFluxStop.readConfig(cfg, 0, cfg.length());
    }

    public static RDFFluxStop noLimit() {
        return NO_LIMIT;
    }

    public static RDFFluxStop countLimit(final long maxTriple) {
        if (maxTriple <= 0L) {
            throw new IllegalArgumentException("Can't have a limit of 0 or a negative value!");
        }
        return new RDFFluxStop(){
            long current = 0L;

            @Override
            public boolean canHandle(TripleString ts) {
                return this.current++ < maxTriple;
            }

            @Override
            public void restart() {
                this.current = 0L;
            }

            @Override
            public String asConfig() {
                return "count:" + maxTriple;
            }
        };
    }

    public static RDFFluxStop sizeLimit(final long maxSize) {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("Can't have a limit of 0 or a negative value!");
        }
        return new RDFFluxStop(){
            long size = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canHandle(TripleString ts) {
                long tsSize;
                try {
                    tsSize = ts.asNtriple().toString().getBytes(StandardCharsets.UTF_8).length;
                }
                catch (IOException e) {
                    throw new RuntimeException("Can't estimate the size of the triple " + ts, e);
                }
                try {
                    boolean bl = this.size < maxSize;
                    return bl;
                }
                finally {
                    this.size += tsSize;
                }
            }

            @Override
            public void restart() {
                this.size = 0L;
            }

            @Override
            public String asConfig() {
                return "size:" + maxSize;
            }
        };
    }

    public abstract boolean canHandle(TripleString var1);

    public abstract void restart();

    public abstract String asConfig();

    public String toString() {
        return this.asConfig();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFFluxStop)) {
            return false;
        }
        RDFFluxStop fluxStop = (RDFFluxStop)obj;
        return this.asConfig().equals(fluxStop.asConfig());
    }

    public RDFFluxStop booleanOp(final RDFFluxStop fluxStop, final char charOperator, final BinaryOperator<Boolean> operator) {
        if (fluxStop == null) {
            return this;
        }
        return new RDFFluxStop(){

            @Override
            public boolean canHandle(TripleString ts) {
                boolean left = RDFFluxStop.this.canHandle(ts);
                boolean right = fluxStop.canHandle(ts);
                return (Boolean)operator.apply(left, right);
            }

            @Override
            public void restart() {
                RDFFluxStop.this.restart();
                fluxStop.restart();
            }

            @Override
            public String asConfig() {
                String left = RDFFluxStop.this.asConfig();
                String right = fluxStop.asConfig();
                return "(" + left + ")" + charOperator + "(" + right + ")";
            }
        };
    }

    public RDFFluxStop and(RDFFluxStop fluxStop) {
        return this.booleanOp(fluxStop, '&', (a, b) -> a != false && b != false);
    }

    public RDFFluxStop or(RDFFluxStop fluxStop) {
        return this.booleanOp(fluxStop, '|', (a, b) -> a != false || b != false);
    }

    public RDFFluxStop not() {
        return EMPTY.booleanOp(this, '!', (a, b) -> b == false);
    }

    static {
        RDFFluxStop.registerCustomRDFFluxStopConfig("count", RDFFluxStop::countLimit);
        RDFFluxStop.registerCustomRDFFluxStopConfig("size", RDFFluxStop::sizeLimit);
        RDFFluxStop.registerCustomRDFFluxStopConfig("no_limit", l -> RDFFluxStop.noLimit());
        RDFFluxStop.registerCustomRDFFluxStopOperator('&', RDFFluxStop::and);
        RDFFluxStop.registerCustomRDFFluxStopOperator('|', RDFFluxStop::or);
        RDFFluxStop.registerCustomRDFFluxStopOperator('!', (a, b) -> b.not());
    }
}

