/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.options;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.rdfhdt.hdt.options.Key;
import org.rdfhdt.hdt.options.Value;

public class HDTOptionsKeys {
    @Key(type=Key.Type.ENUM, desc="Compression mode")
    public static final String LOADER_DISK_COMPRESSION_MODE_KEY = "loader.disk.compressMode";
    @Value(key="loader.disk.compressMode", desc="sort all the file before going to the next step, slower but decrease the RAM usage. default config")
    public static final String LOADER_DISK_COMPRESSION_MODE_VALUE_COMPLETE = "compressionComplete";
    @Value(key="loader.disk.compressMode", desc="sort while reading all the file before going to the next step, faster but increase the RAM usage.")
    public static final String LOADER_DISK_COMPRESSION_MODE_VALUE_PARTIAL = "compressionPartial";
    @Key(type=Key.Type.NUMBER, desc="Number of core used to compress the HDT")
    public static final String LOADER_DISK_COMPRESSION_WORKER_KEY = "loader.disk.compressWorker";
    @Key(type=Key.Type.NUMBER, desc="Maximum size of a chunk")
    public static final String LOADER_DISK_CHUNK_SIZE_KEY = "loader.disk.chunkSize";
    @Key(type=Key.Type.PATH, desc="Location of the disk generation directory")
    public static final String LOADER_DISK_LOCATION_KEY = "loader.disk.location";
    @Key(type=Key.Type.PATH, desc="Location of the future HDT")
    public static final String LOADER_DISK_FUTURE_HDT_LOCATION_KEY = "loader.disk.futureHDTLocation";
    @Key(type=Key.Type.NUMBER, desc="Maximum number of file HDTDisk can open at the same time")
    public static final String LOADER_DISK_MAX_FILE_OPEN_KEY = "loader.disk.maxFileOpen";
    @Key(type=Key.Type.NUMBER, desc="log of the number of way the system can merge in genDisk")
    public static final String LOADER_DISK_KWAY_KEY = "loader.disk.kway";
    @Key(type=Key.Type.NUMBER, desc="Size of the file buffers")
    public static final String LOADER_DISK_BUFFER_SIZE_KEY = "loader.disk.fileBufferSize";
    @Key(type=Key.Type.BOOLEAN, desc="specify that the method doesn't have to copy the triple strings between 2 calls to the iterator")
    public static final String LOADER_DISK_NO_COPY_ITERATOR_KEY = "loader.disk.noCopyIterator";
    @Key(type=Key.Type.ENUM, desc="HDT generation loader type")
    public static final String LOADER_TYPE_KEY = "loader.type";
    @Value(key="loader.type", desc="Using genDisk")
    public static final String LOADER_TYPE_VALUE_DISK = "disk";
    @Value(key="loader.type", desc="Using HDTCat")
    public static final String LOADER_TYPE_VALUE_CAT = "cat";
    @Value(key="loader.type", desc="Using two pass algorithm")
    public static final String LOADER_TYPE_VALUE_TWO_PASS = "two-pass";
    @Value(key="loader.type", desc="Using one pass algorithm")
    public static final String LOADER_TYPE_VALUE_ONE_PASS = "one-pass";
    @Key(type=Key.Type.PATH, desc="Path of the CatTree generation")
    public static final String LOADER_CATTREE_LOCATION_KEY = "loader.cattree.location";
    @Key(type=Key.Type.BOOLEAN, desc="Use async version")
    public static final String LOADER_CATTREE_ASYNC_KEY = "loader.cattree.async";
    @Key(desc="Loader of the hdt generation")
    public static final String LOADER_CATTREE_LOADERTYPE_KEY = "loader.cattree.loadertype";
    @Key(type=Key.Type.PATH, desc="Location of the future HDT")
    public static final String LOADER_CATTREE_FUTURE_HDT_LOCATION_KEY = "loader.cattree.futureHDTLocation";
    @Key(type=Key.Type.DOUBLE, desc="Memory fault factor for HDTCat tree method split")
    public static final String LOADER_CATTREE_MEMORY_FAULT_FACTOR = "loader.cattree.memoryFaultFactor";
    @Key(type=Key.Type.NUMBER, desc="Number of HDT to merge at the same time with K-HDTCat, by default it use the default HDTCat implementation")
    public static final String LOADER_CATTREE_KCAT = "loader.cattree.kcat";
    @Key(type=Key.Type.ENUM, desc="HDTCat supplier type")
    public static final String HDT_SUPPLIER_KEY = "supplier.type";
    @Value(key="supplier.type", desc="using genDisk")
    public static final String LOADER_CATTREE_HDT_SUPPLIER_VALUE_DISK = "disk";
    @Value(key="supplier.type", desc="using gen in memory")
    public static final String LOADER_CATTREE_HDT_SUPPLIER_VALUE_MEMORY = "memory";
    @Key(desc="API use")
    public static final String RDF_FLUX_STOP_KEY = "rdffluxstop.type";
    public static final String RDF_FLUX_STOP_VALUE_SIZE = "size";
    public static final String RDF_FLUX_STOP_VALUE_COUNT = "count";
    public static final String RDF_FLUX_STOP_VALUE_NO_LIMIT = "no_limit";
    public static final char RDF_FLUX_STOP_VALUE_OP_AND = '&';
    public static final char RDF_FLUX_STOP_VALUE_OP_OR = '|';
    public static final char RDF_FLUX_STOP_VALUE_OP_NOT = '!';
    @Key(type=Key.Type.BOOLEAN, desc="Use the profiler to get the time of each section")
    public static final String PROFILER_KEY = "profiler";
    @Key(type=Key.Type.PATH, desc="Profiler output file")
    public static final String PROFILER_OUTPUT_KEY = "profiler.output";
    @Key(type=Key.Type.BOOLEAN, desc="Run a second profiler for async bi tasks")
    public static final String PROFILER_ASYNC_KEY = "profiler.async";
    @Key(type=Key.Type.PATH, desc="Profiler output file")
    public static final String PROFILER_ASYNC_OUTPUT_KEY = "profiler.async.output";
    @Key(type=Key.Type.BOOLEAN, desc="Use the canonical NT file parser, removing checks")
    public static final String NT_SIMPLE_PARSER_KEY = "parser.ntSimpleParser";
    @Key(type=Key.Type.NUMBER, desc="Use async dir parser")
    public static final String ASYNC_DIR_PARSER_KEY = "parser.dir.async";
    @Key(type=Key.Type.STRING, desc="HDT generation triple order")
    public static final String TRIPLE_ORDER_KEY = "triplesOrder";
    @Key(type=Key.Type.ENUM, desc="loading type for HDTCat / HDTDiff")
    public static final String LOAD_HDT_TYPE_KEY = "loader.hdt.type";
    @Value(key="loader.hdt.type", desc="load the HDTs in memory")
    public static final String LOAD_HDT_TYPE_VALUE_LOAD = "load";
    @Value(key="loader.hdt.type", desc="map the HDTs")
    public static final String LOAD_HDT_TYPE_VALUE_MAP = "map";
    @Key(type=Key.Type.ENUM, desc="Internal temporary dictionary")
    public static final String TEMP_DICTIONARY_IMPL_KEY = "tempDictionary.impl";
    @Value(key="tempDictionary.impl", desc="hash dictionary")
    public static final String TEMP_DICTIONARY_IMPL_VALUE_HASH = "hash";
    @Value(key="tempDictionary.impl", desc="hash dictionary with literal count")
    public static final String TEMP_DICTIONARY_IMPL_VALUE_MULT_HASH = "multHash";
    @Value(key="tempDictionary.impl", desc="Prefix AND Suffix front-coded (PSFC) hash dictionary")
    public static final String TEMP_DICTIONARY_IMPL_VALUE_HASH_PSFC = "hashPsfc";
    @Key(type=Key.Type.ENUM, desc="HDT dictionary type")
    public static final String DICTIONARY_TYPE_KEY = "dictionary.type";
    @Value(key="dictionary.type", desc="Four sectiob dictionary")
    public static final String DICTIONARY_TYPE_VALUE_FOUR_SECTION = "<http://purl.org/HDT/hdt#dictionaryFour>";
    @Value(key="dictionary.type", desc="Prefix AND Suffix front-coded (PSFC) four section dictionary")
    public static final String DICTIONARY_TYPE_VALUE_FOUR_PSFC_SECTION = "<http://purl.org/HDT/hdt#dictionaryFourPsfc>";
    @Value(key="dictionary.type", desc="Four section dictionary big")
    public static final String DICTIONARY_TYPE_VALUE_FOUR_SECTION_BIG = "dictionaryFourBig";
    @Value(key="dictionary.type", desc="Multi section dictionary")
    public static final String DICTIONARY_TYPE_VALUE_MULTI_OBJECTS = "dictionaryMultiObj";
    @Key(type=Key.Type.PATH, desc="Location of the HDTCat temp files")
    public static final String HDTCAT_LOCATION = "hdtcat.location";
    @Key(type=Key.Type.PATH, desc="Location of the HDTCat hdt after the loading")
    public static final String HDTCAT_FUTURE_LOCATION = "hdtcat.location.future";
    @Key(type=Key.Type.BOOLEAN, desc="Delete the HDTCat temp files directory after HDTCat, default to true")
    public static final String HDTCAT_DELETE_LOCATION = "hdtcat.deleteLocation";
    @Key(type=Key.Type.BOOLEAN, desc="Use disk implementation to generate the hdt sub-index, default false")
    public static final String BITMAPTRIPLES_SEQUENCE_DISK = "bitmaptriples.sequence.disk";
    @Key(type=Key.Type.BOOLEAN, desc="Use disk 375 subindex implementation to generate the hdt sub-index, default false")
    public static final String BITMAPTRIPLES_SEQUENCE_DISK_SUBINDEX = "bitmaptriples.sequence.disk.subindex";
    @Key(type=Key.Type.PATH, desc="Disk location for the bitmaptriples.sequence.disk option")
    public static final String BITMAPTRIPLES_SEQUENCE_DISK_LOCATION = "bitmaptriples.sequence.disk.location";
    @Key(type=Key.Type.STRING, desc="Bitmap type for the Y bitmap, default <http://purl.org/HDT/hdt#bitmapPlain>")
    public static final String BITMAPTRIPLES_BITMAP_Y = "bitmap.y";
    @Key(type=Key.Type.STRING, desc="Bitmap type for the Z bitmap, default <http://purl.org/HDT/hdt#bitmapPlain>")
    public static final String BITMAPTRIPLES_BITMAP_Z = "bitmap.z";
    @Key(type=Key.Type.STRING, desc="Sequence type for the Y sequence, default <http://purl.org/HDT/hdt#seqLog>")
    public static final String BITMAPTRIPLES_SEQ_Y = "seq.y";
    @Key(type=Key.Type.STRING, desc="Sequence type for the Z sequence, default <http://purl.org/HDT/hdt#seqLog>")
    public static final String BITMAPTRIPLES_SEQ_Z = "seq.z";
    @Key(type=Key.Type.ENUM, desc="Indexing method for the bitmap triples")
    public static final String BITMAPTRIPLES_INDEX_METHOD_KEY = "bitmaptriples.indexmethod";
    @Value(key="bitmaptriples.indexmethod", desc="Recommended implementation, default value")
    public static final String BITMAPTRIPLES_INDEX_METHOD_VALUE_RECOMMENDED = "recommended";
    @Value(key="bitmaptriples.indexmethod", desc="Legacy implementation, fast, but memory inefficient")
    public static final String BITMAPTRIPLES_INDEX_METHOD_VALUE_LEGACY = "legacy";
    @Value(key="bitmaptriples.indexmethod", desc="Disk option, handle the indexing on disk to reduce usage")
    public static final String BITMAPTRIPLES_INDEX_METHOD_VALUE_DISK = "disk";
    @Value(key="bitmaptriples.indexmethod", desc="Memory optimized option")
    public static final String BITMAPTRIPLES_INDEX_METHOD_VALUE_OPTIMIZED = "optimized";
    @Key(type=Key.Type.NUMBER, desc="Number of core used to index the HDT with disk index method.")
    public static final String BITMAPTRIPLES_DISK_WORKER_KEY = "bitmaptriples.indexmethod.disk.compressWorker";
    @Key(type=Key.Type.NUMBER, desc="Maximum size of a chunk")
    public static final String BITMAPTRIPLES_DISK_CHUNK_SIZE_KEY = "bitmaptriples.indexmethod.disk.chunkSize";
    @Key(type=Key.Type.NUMBER, desc="Size of the file buffers")
    public static final String BITMAPTRIPLES_DISK_BUFFER_SIZE_KEY = "bitmaptriples.indexmethod.disk.fileBufferSize";
    @Key(type=Key.Type.NUMBER, desc="Maximum number of file disk index method can open at the same time")
    public static final String BITMAPTRIPLES_DISK_MAX_FILE_OPEN_KEY = "bitmaptriples.indexmethod.disk.maxFileOpen";
    @Key(type=Key.Type.NUMBER, desc="log of the number of way the system can merge in disk index method")
    public static final String BITMAPTRIPLES_DISK_KWAY_KEY = "bitmaptriples.indexmethod.disk.kway";
    private static final Map<String, Option> OPTION_MAP = new TreeMap<String, Option>();

    public static void registerOptionsClass(Class<?> cls) throws Exception {
        for (Field f : cls.getDeclaredFields()) {
            if ((f.getModifiers() & 8) == 0 || (f.getModifiers() & 1) == 0) continue;
            Key key = f.getAnnotation(Key.class);
            if (key != null) {
                String keyValue = String.valueOf(f.get(null));
                OPTION_MAP.put(keyValue, new Option(keyValue, key));
                continue;
            }
            Value value = f.getAnnotation(Value.class);
            if (value == null) continue;
            String valueValue = String.valueOf(f.get(null));
            Option opt = OPTION_MAP.get(value.key());
            if (opt == null) continue;
            opt.values.add(new OptionValue(valueValue, value));
        }
    }

    public static Map<String, Option> getOptionMap() {
        return Collections.unmodifiableMap(OPTION_MAP);
    }

    private HDTOptionsKeys() {
    }

    static {
        try {
            HDTOptionsKeys.registerOptionsClass(HDTOptionsKeys.class);
        }
        catch (Exception e) {
            throw new Error("Can't load option keys", e);
        }
    }

    public static class Option {
        private final String key;
        private final Key keyInfo;
        private final List<OptionValue> values = new ArrayList<OptionValue>();

        private Option(String key, Key keyInfo) {
            this.key = key;
            this.keyInfo = keyInfo;
        }

        public String getKey() {
            return this.key;
        }

        public Key getKeyInfo() {
            return this.keyInfo;
        }

        public List<OptionValue> getValues() {
            return Collections.unmodifiableList(this.values);
        }
    }

    public static class OptionValue {
        private final String value;
        private final Value valueInfo;

        private OptionValue(String value, Value valueInfo) {
            this.value = value;
            this.valueInfo = valueInfo;
        }

        public String getValue() {
            return this.value;
        }

        public Value getValueInfo() {
            return this.valueInfo;
        }
    }
}

