/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.options;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.options.HDTOptionsKeys;
import org.rdfhdt.hdt.rdf.RDFFluxStop;
import org.rdfhdt.hdt.util.Profiler;

public interface HDTOptions {
    public static final HDTOptions EMPTY = new HDTOptions(){

        @Override
        public void clear() {
        }

        @Override
        public String get(String key) {
            return null;
        }

        @Override
        public void set(String key, String value) {
            throw new NotImplementedException("set");
        }

        @Override
        public Set<?> getKeys() {
            return Collections.emptySet();
        }
    };

    public static HDTOptions of() {
        final TreeMap map = new TreeMap();
        return new HDTOptions(){

            @Override
            public void clear() {
                map.clear();
            }

            @Override
            public String get(String key) {
                return (String)map.get(key);
            }

            @Override
            public void set(String key, String value) {
                map.put(key, value);
            }

            public Set<String> getKeys() {
                return Collections.unmodifiableSet(map.keySet());
            }
        };
    }

    public static HDTOptions of(Map<?, ?> data) {
        Objects.requireNonNull(data, "data map can't be null!");
        HDTOptions opt = HDTOptions.of();
        opt.setOptions(data);
        return opt;
    }

    public static HDTOptions of(Object ... data) {
        Objects.requireNonNull(data, "data can't be null!");
        HDTOptions opt = HDTOptions.of();
        opt.setOptions(data);
        return opt;
    }

    public static HDTOptions ofNullable(HDTOptions options) {
        return Objects.requireNonNullElse(options, EMPTY);
    }

    public static HDTOptions readFromFile(Path filename) throws IOException {
        return HDTManager.readOptions(Objects.requireNonNull(filename, "filename can't be null!"));
    }

    public static HDTOptions readFromFile(String filename) throws IOException {
        return HDTManager.readOptions(Objects.requireNonNull(filename, "filename can't be null!"));
    }

    public void clear();

    public String get(String var1);

    default public Set<?> getKeys() {
        throw new NotImplementedException("getKeys");
    }

    default public String get(String key, String defaultValue) {
        return Objects.requireNonNullElse(this.get(key), defaultValue);
    }

    default public String get(String key, Supplier<String> defaultValue) {
        return Objects.requireNonNullElseGet(this.get(key), defaultValue);
    }

    default public boolean getBoolean(String key) {
        return "true".equalsIgnoreCase(this.get(key));
    }

    default public boolean getBoolean(String key, boolean defaultValue) {
        String v = this.get(key);
        if (v == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(v);
    }

    default public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    default public double getDouble(String key, DoubleSupplier defaultValue) {
        String l = this.get(key);
        if (l == null) {
            return defaultValue.getAsDouble();
        }
        return Double.parseDouble(l);
    }

    default public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, () -> defaultValue);
    }

    default public RDFFluxStop getFluxStop(String key) {
        return RDFFluxStop.readConfig(this.get(key));
    }

    default public RDFFluxStop getFluxStop(String key, Supplier<RDFFluxStop> defaultValue) {
        return Objects.requireNonNullElseGet(this.getFluxStop(key), defaultValue);
    }

    default public RDFFluxStop getFluxStop(String key, RDFFluxStop defaultValue) {
        return this.getFluxStop(key, () -> defaultValue);
    }

    default public long getInt(String key) {
        return this.getInt(key, 0L);
    }

    default public long getInt(String key, LongSupplier defaultValue) {
        String l = this.get(key);
        if (l == null) {
            return defaultValue.getAsLong();
        }
        return Long.parseLong(l);
    }

    default public long getInt(String key, long defaultValue) {
        return this.getInt(key, () -> defaultValue);
    }

    default public void load(Path filename) throws IOException {
        Objects.requireNonNull(filename, "filename can't be null");
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(filename, new OpenOption[0]);){
            properties.load(is);
        }
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.set(String.valueOf(k), v)));
    }

    default public void load(String filename) throws IOException {
        this.load(Path.of(Objects.requireNonNull(filename, "filename can't be null"), new String[0]));
    }

    public void set(String var1, String var2);

    default public void set(String key, Object value) {
        if (value instanceof RDFFluxStop) {
            this.set(key, (RDFFluxStop)value);
        } else {
            this.set(key, String.valueOf(value));
        }
    }

    default public void set(String key, RDFFluxStop fluxStop) {
        this.set(key, fluxStop.asConfig());
    }

    default public void set(String key, Profiler profiler) {
        this.set(key, "!" + profiler.getId());
    }

    default public void setInt(String key, long value) {
        this.set(key, String.valueOf(value));
    }

    default public void setOptions(String options) {
        for (String item : options.split(";")) {
            int pos = item.indexOf(61);
            if (pos == -1) continue;
            String property = item.substring(0, pos);
            String value = item.substring(pos + 1);
            this.set(property, value);
        }
    }

    default public void setOptions(Map<?, ?> options) {
        options.forEach((k, v) -> this.set(String.valueOf(k), v));
    }

    default public void setOptions(Object ... options) {
        if ((options.length & 1) != 0) {
            throw new IllegalArgumentException("options.length should be even!");
        }
        int len = options.length >> 1;
        for (int i = 0; i < len; ++i) {
            String key = String.valueOf(options[i << 1]);
            Object value = options[i << 1 | 1];
            this.set(key, value);
        }
    }

    default public void write(Path file) throws IOException {
        this.write(file, true);
    }

    default public void write(Path file, boolean withComment) throws IOException {
        try (BufferedWriter w = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.write(w, withComment);
        }
    }

    default public void write(Writer w, boolean withComment) throws IOException {
        Map<String, HDTOptionsKeys.Option> optionMap = HDTOptionsKeys.getOptionMap();
        for (Object okey : this.getKeys()) {
            HDTOptionsKeys.Option opt;
            String key = String.valueOf(okey);
            String value = this.get(key);
            if (withComment && (opt = optionMap.get(key)) != null) {
                w.write("# " + opt.getKeyInfo().desc() + "\n# Type: " + opt.getKeyInfo().type().getTitle() + "\n");
            }
            w.write(key + "=" + value + "\n");
        }
    }
}

