/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.TripleString;

@FunctionalInterface
public interface HDTSupplier {
    public static final Map<String, HDTSupplier> SUPPLIERS = new HashMap<String, HDTSupplier>(){
        {
            this.put("memory", HDTSupplier.memory());
            this.put("disk", HDTSupplier.disk());
        }
    };

    public static HDTSupplier memory() {
        return (iterator, baseURI, hdtFormat, listener, location) -> {
            try (HDT hdt = HDTManager.generateHDT(iterator, baseURI, hdtFormat, listener);){
                hdt.saveToHDT(location.toAbsolutePath().toString(), listener);
            }
        };
    }

    public static HDTSupplier disk() {
        return (iterator, baseURI, hdtFormat, listener, location) -> {
            hdtFormat.set("loader.disk.futureHDTLocation", location.toAbsolutePath().toString());
            HDTManager.generateHDTDisk(iterator, baseURI, hdtFormat, listener).close();
        };
    }

    public static HDTSupplier fromSpec(HDTOptions spec) {
        if (spec == null) {
            return HDTSupplier.memory();
        }
        String supplier = spec.get("supplier.type");
        if (supplier == null || supplier.isEmpty()) {
            return HDTSupplier.memory();
        }
        HDTSupplier s = SUPPLIERS.get(supplier);
        if (s == null) {
            throw new IllegalArgumentException("Can't find a supplier for name: " + supplier);
        }
        return s;
    }

    public void doGenerateHDT(Iterator<TripleString> var1, String var2, HDTOptions var3, ProgressListener var4, Path var5) throws IOException, ParserException;
}

