/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.enums.CompressionType;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTSupplier;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.RDFFluxStop;
import org.rdfhdt.hdt.rdf.TripleWriter;
import org.rdfhdt.hdt.triples.TripleString;

public abstract class HDTManager {
    private static HDTManager instance;

    private static HDTManager getInstance() {
        if (instance == null) {
            try {
                Class<?> managerImplClass = Class.forName("org.rdfhdt.hdt.pro.HDTManagerProImpl");
                instance = (HDTManager)managerImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e1) {
                try {
                    Class<?> managerImplClass = Class.forName("org.rdfhdt.hdt.hdt.HDTManagerImpl");
                    instance = (HDTManager)managerImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class org.rdfhdt.hdt.hdt.HDTManagerImpl not found. Did you include the HDT implementation jar?", e);
                }
                catch (InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException("Cannot create implementation for HDTManager. Does the class org.rdfhdt.hdt.hdt.HDTManagerImpl inherit from HDTManager?", e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Cannot create implementation for HDTManager. Does the class org.rdfhdt.hdt.hdt.HDTManagerImpl has a default empty constructor?", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return instance;
    }

    public static HDTOptions readOptions(Path file) throws IOException {
        return HDTManager.readOptions(file.toAbsolutePath().toString());
    }

    public static HDTOptions readOptions(String file) throws IOException {
        return HDTManager.getInstance().doReadOptions(file);
    }

    public static HDT loadHDT(Path hdtFileName, ProgressListener listener, HDTOptions hdtFormat) throws IOException {
        return HDTManager.loadHDT(hdtFileName.toAbsolutePath().toString(), listener, hdtFormat);
    }

    public static HDT loadHDT(String hdtFileName, ProgressListener listener, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doLoadHDT(hdtFileName, ProgressListener.ofNullable(listener), HDTOptions.ofNullable(hdtFormat));
    }

    public static HDT loadHDT(Path hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.loadHDT(hdtFileName.toAbsolutePath().toString(), listener);
    }

    public static HDT loadHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.loadHDT(hdtFileName, listener, null);
    }

    public static HDT loadHDT(Path hdtFileName) throws IOException {
        return HDTManager.loadHDT(hdtFileName.toAbsolutePath().toString());
    }

    public static HDT loadHDT(String hdtFileName) throws IOException {
        return HDTManager.loadHDT(hdtFileName, null, null);
    }

    public static HDT mapHDT(Path hdtFileName, ProgressListener listener, HDTOptions hdtFormat) throws IOException {
        return HDTManager.mapHDT(hdtFileName.toAbsolutePath().toString(), listener, hdtFormat);
    }

    public static HDT mapHDT(String hdtFileName, ProgressListener listener, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doMapHDT(hdtFileName, ProgressListener.ofNullable(listener), HDTOptions.ofNullable(hdtFormat));
    }

    public static HDT mapHDT(Path hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.mapHDT(hdtFileName.toAbsolutePath().toString(), listener);
    }

    public static HDT mapHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.mapHDT(hdtFileName, listener, null);
    }

    public static HDT mapHDT(Path hdtFileName) throws IOException {
        return HDTManager.mapHDT(hdtFileName.toAbsolutePath().toString());
    }

    public static HDT mapHDT(String hdtFileName) throws IOException {
        return HDTManager.mapHDT(hdtFileName, null, null);
    }

    public static HDT loadHDT(InputStream hdtFile, ProgressListener listener, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doLoadHDT(hdtFile, ProgressListener.ofNullable(listener), HDTOptions.ofNullable(hdtFormat));
    }

    public static HDT loadHDT(InputStream hdtFile, ProgressListener listener) throws IOException {
        return HDTManager.loadHDT(hdtFile, listener, null);
    }

    public static HDT loadHDT(InputStream hdtFile) throws IOException {
        return HDTManager.loadHDT(hdtFile, null, null);
    }

    public static HDT loadIndexedHDT(Path hdtFileName, ProgressListener listener, HDTOptions hdtFormat) throws IOException {
        return HDTManager.loadIndexedHDT(hdtFileName.toAbsolutePath().toString(), listener, hdtFormat);
    }

    public static HDT loadIndexedHDT(Path hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.loadIndexedHDT(hdtFileName.toAbsolutePath().toString(), listener);
    }

    public static HDT loadIndexedHDT(Path hdtFileName) throws IOException {
        return HDTManager.loadIndexedHDT(hdtFileName.toAbsolutePath().toString());
    }

    public static HDT loadIndexedHDT(String hdtFileName, ProgressListener listener, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doLoadIndexedHDT(hdtFileName, ProgressListener.ofNullable(listener), HDTOptions.ofNullable(hdtFormat));
    }

    public static HDT loadIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.loadIndexedHDT(hdtFileName, listener, null);
    }

    public static HDT loadIndexedHDT(String hdtFileName) throws IOException {
        return HDTManager.loadIndexedHDT(hdtFileName, null, null);
    }

    public static HDT mapIndexedHDT(Path hdtFileName, HDTOptions spec, ProgressListener listener) throws IOException {
        return HDTManager.mapIndexedHDT(hdtFileName.toAbsolutePath().toString(), spec, listener);
    }

    public static HDT mapIndexedHDT(Path hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.mapIndexedHDT(hdtFileName.toAbsolutePath().toString(), ProgressListener.ofNullable(listener));
    }

    public static HDT mapIndexedHDT(Path hdtFileName) throws IOException {
        return HDTManager.mapIndexedHDT(hdtFileName.toAbsolutePath().toString());
    }

    public static HDT mapIndexedHDT(String hdtFileName, HDTOptions spec, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doMapIndexedHDT(hdtFileName, ProgressListener.ofNullable(listener), HDTOptions.ofNullable(spec));
    }

    public static HDT mapIndexedHDT(String hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.mapIndexedHDT(hdtFileName, null, listener);
    }

    public static HDT mapIndexedHDT(String hdtFileName) throws IOException {
        return HDTManager.mapIndexedHDT(hdtFileName, null, null);
    }

    public static HDT loadIndexedHDT(InputStream hdtFileName, ProgressListener listener) throws IOException {
        return HDTManager.loadIndexedHDT(hdtFileName, listener, null);
    }

    public static HDT loadIndexedHDT(InputStream hdtFileName) throws IOException {
        return HDTManager.loadIndexedHDT(hdtFileName, null, null);
    }

    public static HDT loadIndexedHDT(InputStream hdtFileName, ProgressListener listener, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doLoadIndexedHDT(hdtFileName, ProgressListener.ofNullable(listener), HDTOptions.ofNullable(hdtFormat));
    }

    public static HDT indexedHDT(HDT hdt, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doIndexedHDT(hdt, ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDT(Path rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.generateHDT(rdfFileName.toAbsolutePath().toString(), baseURI, rdfNotation, hdtFormat, listener);
    }

    public static HDT generateHDT(String rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(rdfFileName, baseURI, rdfNotation, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDT(Iterator<TripleString> iterator, String baseURI, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(iterator, baseURI, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDT(InputStream fileStream, String baseURI, String filename, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(fileStream, baseURI, RDFNotation.guess(filename), CompressionType.guess(filename), HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDT(InputStream fileStream, String baseURI, RDFNotation rdfNotation, CompressionType compressionType, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(fileStream, baseURI, rdfNotation, compressionType, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDT(InputStream fileStream, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDT(fileStream, baseURI, rdfNotation, CompressionType.NONE, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDTDisk(String rdfFileName, String baseURI, RDFNotation rdfNotation, CompressionType compressionType, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDTDisk(rdfFileName, baseURI, rdfNotation, compressionType, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDTDisk(String rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDTDisk(rdfFileName, baseURI, rdfNotation, CompressionType.NONE, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDTDisk(String rdfFileName, String baseURI, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDTDisk(rdfFileName, baseURI, RDFNotation.guess(rdfFileName), CompressionType.guess(rdfFileName), HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDTDisk(InputStream fileStream, String baseURI, String filename, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDTDisk(fileStream, baseURI, RDFNotation.guess(filename), CompressionType.guess(filename), HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDTDisk(InputStream fileStream, String baseURI, RDFNotation rdfNotation, CompressionType compressionType, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDTDisk(fileStream, baseURI, rdfNotation, compressionType, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDTDisk(InputStream fileStream, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDTDisk(fileStream, baseURI, rdfNotation, CompressionType.NONE, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT generateHDTDisk(Iterator<TripleString> iterator, String baseURI, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doGenerateHDTDisk(iterator, baseURI, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static TripleWriter getHDTWriter(OutputStream out, String baseURI, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doGetHDTWriter(out, baseURI, HDTOptions.ofNullable(hdtFormat));
    }

    public static TripleWriter getHDTWriter(Path outFile, String baseURI, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getHDTWriter(outFile.toAbsolutePath().toString(), baseURI, hdtFormat);
    }

    public static TripleWriter getHDTWriter(String outFile, String baseURI, HDTOptions hdtFormat) throws IOException {
        return HDTManager.getInstance().doGetHDTWriter(outFile, baseURI, HDTOptions.ofNullable(hdtFormat));
    }

    public static HDT catHDT(Path location, Path hdtFileName1, Path hdtFileName2, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.catHDT(location.toAbsolutePath().toString(), hdtFileName1.toAbsolutePath().toString(), hdtFileName2.toAbsolutePath().toString(), hdtFormat, listener);
    }

    public static HDT catHDT(String location, String hdtFileName1, String hdtFileName2, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doHDTCat(location, hdtFileName1, hdtFileName2, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT catHDTPath(List<Path> hdtFileNames, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.catHDT(hdtFileNames.stream().map(p -> p.toAbsolutePath().toString()).collect(Collectors.toList()), hdtFormat, listener);
    }

    public static HDT catHDT(List<String> hdtFileNames, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doHDTCat(hdtFileNames, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT diffHDT(Path hdtFileName1, Path hdtFileName2, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.diffHDT(hdtFileName1.toAbsolutePath().toString(), hdtFileName2.toAbsolutePath().toString(), hdtFormat, listener);
    }

    public static HDT diffHDT(String hdtFileName1, String hdtFileName2, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doHDTDiff(hdtFileName1, hdtFileName2, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT diffHDTBit(Path location, String hdtFileName, Bitmap deleteBitmap, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.diffHDTBit(location.toAbsolutePath().toString(), hdtFileName, deleteBitmap, hdtFormat, listener);
    }

    public static HDT diffHDTBit(String location, String hdtFileName, Bitmap deleteBitmap, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doHDTDiffBit(location, hdtFileName, deleteBitmap, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT diffBitCatHDTPath(List<Path> hdtFileNames, List<? extends Bitmap> deleteBitmaps, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.diffBitCatHDT(hdtFileNames.stream().map(p -> p.toAbsolutePath().toString()).collect(Collectors.toList()), deleteBitmaps, hdtFormat, listener);
    }

    public static HDT diffBitCatHDT(List<String> hdtFileNames, List<? extends Bitmap> deleteBitmaps, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        return HDTManager.getInstance().doHDTDiffBitCat(hdtFileNames, deleteBitmaps, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT catTree(RDFFluxStop fluxStop, HDTSupplier supplier, Path rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.catTree(fluxStop, supplier, rdfFileName.toAbsolutePath().toString(), baseURI, rdfNotation, hdtFormat, listener);
    }

    public static HDT catTree(RDFFluxStop fluxStop, HDTSupplier supplier, String rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doHDTCatTree(fluxStop, supplier, rdfFileName, baseURI, rdfNotation, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT catTree(RDFFluxStop fluxStop, HDTSupplier supplier, InputStream rdfStream, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doHDTCatTree(fluxStop, supplier, rdfStream, baseURI, rdfNotation, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    public static HDT catTree(RDFFluxStop fluxStop, HDTSupplier supplier, Iterator<TripleString> iterator, String baseURI, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        return HDTManager.getInstance().doHDTCatTree(fluxStop, supplier, iterator, baseURI, HDTOptions.ofNullable(hdtFormat), ProgressListener.ofNullable(listener));
    }

    protected abstract HDTOptions doReadOptions(String var1) throws IOException;

    protected abstract HDT doLoadHDT(String var1, ProgressListener var2, HDTOptions var3) throws IOException;

    protected abstract HDT doLoadHDT(InputStream var1, ProgressListener var2, HDTOptions var3) throws IOException;

    protected abstract HDT doMapHDT(String var1, ProgressListener var2, HDTOptions var3) throws IOException;

    protected abstract HDT doLoadIndexedHDT(String var1, ProgressListener var2, HDTOptions var3) throws IOException;

    protected abstract HDT doLoadIndexedHDT(InputStream var1, ProgressListener var2, HDTOptions var3) throws IOException;

    protected abstract HDT doMapIndexedHDT(String var1, ProgressListener var2, HDTOptions var3) throws IOException;

    protected abstract HDT doIndexedHDT(HDT var1, ProgressListener var2) throws IOException;

    protected abstract HDT doGenerateHDT(String var1, String var2, RDFNotation var3, HDTOptions var4, ProgressListener var5) throws IOException, ParserException;

    protected abstract HDT doGenerateHDT(InputStream var1, String var2, RDFNotation var3, CompressionType var4, HDTOptions var5, ProgressListener var6) throws IOException, ParserException;

    protected abstract HDT doGenerateHDT(Iterator<TripleString> var1, String var2, HDTOptions var3, ProgressListener var4) throws IOException;

    protected abstract HDT doGenerateHDTDisk(String var1, String var2, RDFNotation var3, CompressionType var4, HDTOptions var5, ProgressListener var6) throws IOException, ParserException;

    protected abstract HDT doGenerateHDTDisk(InputStream var1, String var2, RDFNotation var3, CompressionType var4, HDTOptions var5, ProgressListener var6) throws IOException, ParserException;

    protected abstract HDT doGenerateHDTDisk(Iterator<TripleString> var1, String var2, HDTOptions var3, ProgressListener var4) throws IOException, ParserException;

    protected abstract TripleWriter doGetHDTWriter(OutputStream var1, String var2, HDTOptions var3) throws IOException;

    protected abstract TripleWriter doGetHDTWriter(String var1, String var2, HDTOptions var3) throws IOException;

    protected abstract HDT doHDTCat(String var1, String var2, String var3, HDTOptions var4, ProgressListener var5) throws IOException;

    protected abstract HDT doHDTCat(List<String> var1, HDTOptions var2, ProgressListener var3) throws IOException;

    protected abstract HDT doHDTDiffBitCat(List<String> var1, List<? extends Bitmap> var2, HDTOptions var3, ProgressListener var4) throws IOException;

    protected abstract HDT doHDTDiff(String var1, String var2, HDTOptions var3, ProgressListener var4) throws IOException;

    protected abstract HDT doHDTDiffBit(String var1, String var2, Bitmap var3, HDTOptions var4, ProgressListener var5) throws IOException;

    protected abstract HDT doHDTCatTree(RDFFluxStop var1, HDTSupplier var2, String var3, String var4, RDFNotation var5, HDTOptions var6, ProgressListener var7) throws IOException, ParserException;

    protected abstract HDT doHDTCatTree(RDFFluxStop var1, HDTSupplier var2, InputStream var3, String var4, RDFNotation var5, HDTOptions var6, ProgressListener var7) throws IOException, ParserException;

    protected abstract HDT doHDTCatTree(RDFFluxStop var1, HDTSupplier var2, Iterator<TripleString> var3, String var4, HDTOptions var5, ProgressListener var6) throws IOException, ParserException;
}

